% function ents = loadKBfromDirectory(kbdir)
%
% simply loads in every .xml file in the directory, assuming it is an entity definition.
%
% HISTORY: created 4/9/09 Tom
% WARNING: this is probably LINUX-specific, since it assumes directory listing includes the first
% to lines '.' and '..'

function count = loadKBfromDirectory(kbdir, count)
global THEO

DEBUG=1;
if nargin<2
  count=0;
end

Original.THEO.kbSubdirDepth = THEO.kbSubdirDepth;
THEO.kbSubdirDepth=0;

files = dir(kbdir);
% ignore files one and two, they're just '.' and '..'
files=files(3:end);
isdirs=[files.isdir];
for k=1:length(files)
  if isdirs(k)
    count=loadKBfromDirectory([kbdir, files(k).name, filesep], count);
  else
    [pathstr, name, ext, versn] = fileparts(files(k).name);
    if strcmp('.xml',ext)
      if DEBUG display(name); end
      if 0==mod(count,1000) fprintf('.'); end
      loadEntityBare(name,kbdir);
      count=count+1;
    end
  end
end

THEO.kbSubdirDepth = Original.THEO.kbSubdirDepth;
