% loadEntityBare(entity <kbdir>)
%
%  Load an entity from kbdir (defaults to THEO.kbdir if not provided).  
%
%  Matlab's xmlread, xmlwrite are based on Java org.apache.xerces.dom.DeferredDocumentImpl
%
% HISTORY
% Created 4/9/2009 by Tom, copy and edit of loadEntity.m
% 4/26/09 Tom: added trimming of whitespace from begin and end of entity names
% 5/20/09 Tom: added call to entToFilename to calculate entity location

function fileName = loadEntityBare(entity, kbdir)
global THEO

if nargin<2
  kbdir=THEO.kbdir;
end

% turn these off during execution of load
OLDmaintainDiskHierarchy=THEO.maintainDiskHierarchy;
OLDmaintainDiskKB=THEO.maintainDiskKB;
THEO.maintainDiskHierarchy=0;
THEO.maintainDiskKB=0;

% fileName=sprintf('%s%s.xml',kbdir,entity);
fileName=entToFilename(entity,kbdir);

xDoc = xmlread(fileName); % read in the entity DOM
xRoot = xDoc.getDocumentElement; % its top level obj must be an "entity"
if ~strcmp('entity',xRoot.getTagName)
  fprintf('** ERROR: root node of ~s should be an ENTITY DOM object ***\n', ...
          fileName);
  return
end

% Java assigns DOM nodes integer types, so redefine them here
textNode=3;
element=1;

% child 0 of the entity is empty (presumably the empty text node that
% goes with the <entity> tag.  Child 1 contains the entityName

if xRoot.hasChildNodes % it would be unusual to have no child nodes...
  entChildren = xRoot.getChildNodes;
  
  % next statement uses 'char' to coerce java.lang.String to matlab string
  entityName = char(xRoot.getChildNodes.item(1).getFirstChild.getData);

  % entity names should never begin or end with spaces, or contain a CR (ASCII code 13 decimal = char(13))
  % the first line below (commented out) is all we should need, but second line does more
  % agressive cleanup
  %%%%%%%%%%% entityName=strtrim(entityName);
  entityName=string2entityName(entityName);
  
  % create the THEO variable to store in RAM, and add to THEO.entities
  createEntityBare(entityName); 
  
  % now go through remaining children, which should be slots and
  % their values (last "child" is the empty array, so ignore it).
  % For each slot, call createSlotFromDOMnode(node, entityName),
  % where entityName can be a list indicating a subslot.
  for k=2:(entChildren.getLength-1)
    if (entChildren.item(k).getNodeType == element) && strcmp('slot',char(entChildren.item(k).getNodeName))
      % Only process element nodes that define slots - others are empty
      createSlotFromDOMnode(entChildren.item(k),entityName);
    end
  end
end
THEO.maintainDiskHierarchy=OLDmaintainDiskHierarchy;
THEO.maintainDiskKB=OLDmaintainDiskKB;


% create slot, its value, and its subslots, recursively
% DEBUGGING: node=entChildren.item(k)
function [] = createSlotFromDOMnode(node,entityName)
global THEO
% following are Java-defined integers for node types
debug=0;
textNode=3;
element=1;

nodeChildren = node.getChildNodes;
for k=1:(nodeChildren.getLength-1)
  if debug
    fprintf('DEBUG: k = %d\n');
  end
  if (nodeChildren.item(k).getNodeType == element) 
    % only process element nodes - others are empty
    child=nodeChildren.item(k);
    tagName= char(child.getTagName);
    if strcmp(tagName,'slot')
      createSlotFromDOMnode(child, entSlot2entAddr(entityName, slotName));
    elseif strcmp(tagName,'name')
      slotName= char(child.getFirstChild.getData);
    elseif strcmp(tagName, 'val')
      valNode=child.getFirstChild;
      val = createMatlabTypeFromXMLtype(valNode);
      if debug
        fprintf('pv(%s,%s,%s)\n', slotName, v2p(entityName), v2p(val));
      end
      putValueBare(slotName, entityName, val);
    end
  end
end

  
