% loadEntity(entity <kbdir>)
%
%  Load an entity from kbdir (defaults to THEO.kbdir if not provided).  Needs some work to correctly
%  link generalizations and specializations when some are in and some are out of memory.  Should
%  write a fn 'loadHierarchyUnder(entity)' which would be nice and clean...
%
%  Matlab's xmlread, xmlwrite are based on Java org.apache.xerces.dom.DeferredDocumentImpl
%
% HISTORY
% Created 12/7/2008 by Tom
% 2/1/09 Tom added code to temporarily disable THEO.maintainDiskKB, THEO.maintainDiskHierarchy
% 3/2/09 Tom added optional second argument kbdir
% 5/20/09 Tom added call to entToFilename to compute file location of entity


function fileName = loadEntity(entity kbdir)
global THEO

if nargin<2
  kbdir=THEO.kbdir;
end

% turn these off during execution of load
OLDmaintainDiskHierarchy=THEO.maintainDiskHierarchy;
OLDmaintainDiskKB=THEO.maintainDiskKB;
THEO.maintainDiskHierarchy=0;
THEO.maintainDiskKB=0;

%fileName=sprintf('%s%s.xml',kbdir,entity);
fileName=entToFilename(entity,kbdir);

xDoc = xmlread(fileName); % read in the entity DOM
xRoot = xDoc.getDocumentElement; % its top level obj must be an "entity"
if ~strcmp('entity',xRoot.getTagName)
  fprintf('** ERROR: root node of ~s should be an ENTITY DOM object ***\n', ...
          fileName);
  return
end

% Java assigns DOM nodes integer types, so redefine them here
textNode=3;
element=1;

% child 0 of the entity is empty (presumably the empty text node that
% goes with the <entity> tag.  Child 1 contains the entityName

if xRoot.hasChildNodes % it would be unusual to have no child nodes...
  entChildren = xRoot.getChildNodes;
  % next statement uses 'char' to coerce java.lang.String to matlab string
  entityName = char(xRoot.getChildNodes.item(1).getFirstChild.getData);
  
  createEntity(entityName);
  
  % now go through remaining children, which should be slots and
  % their values (last "child" is the empty array, so ignore it).
  % For each slot, call createSlotFromDOMnode(node, entityName),
  % where entityName can be a list indicating a subslot.
  for k=2:(entChildren.getLength-1)
    if (entChildren.item(k).getNodeType == element) && strcmp('slot',char(entChildren.item(k).getNodeName))
      % only process element nodes that define slots - others are empty
      createSlotFromDOMnode(entChildren.item(k),entityName);
    end
  end
end
THEO.maintainDiskHierarchy=OLDmaintainDiskHierarchy;
THEO.maintainDiskKB=OLDmaintainDiskKB;


% create slot, its value, and its subslots, recursively
function [] = createSlotFromDOMnode(node,entityName)
global THEO
% following are Java-defined integers for node types
textNode=3;
element=1;

nodeChildren = node.getChildNodes;
for k=1:(nodeChildren.getLength-1)
  if (nodeChildren.item(k).getNodeType == element) 
    % only process element nodes - others are empty
    child=nodeChildren.item(k);
    tagName= char(child.getTagName);
    if strcmp(tagName,'slot')
      createSlotFromDOMnode(child, entSlot2entAddr(entityName, slotName));
    elseif strcmp(tagName,'name')
      slotName= char(child.getFirstChild.getData);
    elseif strcmp(tagName, 'val')
      valNode=child.getFirstChild;
      val = createMatlabTypeFromXMLtype(valNode);
      %%  need in the following to parse XML type tokens first...
      fprintf('pv(%s,%s,%s)\n', slotName, value2printString(entityName), value2printString(val));
      putValueBare(slotName, entityName, val);
    end
  end
end

  

%%%%%%%%%%%%%%%%%%%
% Just testing below here.
%
% HINTS FROM http://www.w3schools.com/xml/xml_dom.asp
% NOTE: you must use Java numbering for lists, begin with index=0.
% NOTE: use  xxx.getClass to find out the Java class returned to matlab.
% 
% In the examples below we use the following DOM reference to get the text from the <to> element:
%
% xmlDoc.getElementsByTagName("to")[0].childNodes[0].nodeValue
%
% xmlDoc - the XML document created by the parser.
% getElementsByTagName("to")[0] - the first <to> element
% childNodes[0] - the first child of the <to> element (the text node)
% nodeValue - the value of the node (the text itself)
% You can learn more about the XML DOM in our XML DOM tutorial.
%%%%%%%%%%%%%%%%%%%%
if 0
  if xRoot.hasChildNodes
    firstChild=xRoot.getFirstChild()
    firstChild.getNodeName
    firstChild.getNodeType
    firstChild.getNextSibling
    firstChild.getNextSibling.getNodeName  %% this returns: 'entityName'
    childNodes=xRoot.getChildNodes()
    xRoot.getElementsByTagName('entityName').getLength 
    xRoot.getElementsByTagName('slot').getLength 
    xRoot.getElementsByTagName('val').getLength 
    xRoot.getElementsByTagName('s').getLength 
    
  end
  
  % WHAT WE WANT: xmlDoc.getElementsByTagName("to")[0].childNodes[0].nodeValue
  z=xRoot.getElementsByTagName('entityName').getLength
  z=xRoot.getElementsByTagName('entityName').item(1).childNodes
  z=xRoot.getElementsByTagName('entityName').item(0).getFirstChild
  z=xRoot.getElementsByTagName('entityName').item(0).getChildNodes.item(0).getClass
  z=xRoot.getElementsByTagName('entityName').item(0).getChildNodes.item(0).getData
  
  z=xRoot.getElementsByTagName('entityName').item(0).getChildNodes.item(0).getData
  
end

%%%%%%%%%%%%%% ABOVE HERE ALL WORK CORRECTLY IN MATLAB....  %%%%%%%%%%%%%%%%
