% isSourceRule(slot,ent,rule, <n=0>)
% 
% searches to see whether input rule is contained in the 'source' subslot of slot of ent (assumes
% the source format used by the prolog method).  If so, returns an integer indicating which position
% in the list of sources contains this source.  Otherwise,returns 0.  If the optional argument n
% is provided, then it considers only the nth value of source (useful for checking whether a given
% rule is the source for the nth value of slot.  If n=0 (which is the default), then it considers
% all members of source, and returns the integer corresponding to the first match.
%
% input rule looks like this:
% {{{plays_sport_team, ?x, ?y} , {team_members, ?x, ?z} , {plays_sport, ?z, ?y} } , 0.78005, 17, 3, 5} 
%
% HISTORY
% created 6/7/09 Tom

function rslt = isSourceRule(slot,ent,rule,n)
if nargin<4
  n=0;
end

rslt=0;
eaddr=entSlot2entAddr(ent,slot);
sources=getValueBare('source',eaddr);
if ~isTheoValue(sources)
  return;
elseif n>length(sources)
  return;
else
  if n==0
    locs=[1:length(sources)]; % consider all sources
  else
    locs=[n]; % or just the one indicated by input n
  end
  for k=locs
    for j=1:length(sources{k})
      % display([k j]);
      % display(v2p(sources{k}{j}{2}));
      if memberOf(rule, sources{k}{j}{2})
        rslt=k;
        return;
      end
    end
  end
end
