% isSource(slot,ent,source,<n=0>)
% 
% searches to see whether input source is contained in the 'source' subslot of slot of ent.  If so,
% returns an integer indicating which position in the list of sources contains this source.
% Otherwise,returns 0.  If the optional argument n is provided, and it is non-zero, then it
% considers only the nth value of source (useful for checking whether a given source corresponds to
% just the nth value of slot.  If n=0 (which is the default), then it considers all members of
% source, and returns the integer corresponding to the first match.  
%
% HISTORY created 6/7/09 Tom

function rslt = isSource(slot,ent,source,n)
if nargin<4
  n=0;
end

rslt=0;
eaddr=entSlot2entAddr(ent,slot);
sources=getValueBare('source',eaddr);
if ~isTheoValue(sources)
  return;
elseif n>length(sources)
  return;
else
  if n==0
    locs=[1:length(sources)] % consider all sources
  else
    locs=[n] % or just the one indicated by input n
  end
  for k=locs
    loc=memberOf(source, sources{k});
    if loc>0
      rslt=k; % it's part of the kth source
      return;
    end
  end
end
