% function rslt = isEntityOnWeb(entity)
% 
% Returns 1 if entity exists on the web at site THEO.kbdir, else 0.  If input entity is cell
% array, just checks (for efficiency) whether the top level (first element in the cell array)
% entity exists on the web.
%
% HISTORY
% 9/7/09 Created by Tom (analogous to isEntityOnDisk)
% 9/8/09 Tom: added check and handling for when the input 'entity' is a cell array

% Suggested upgrade: should worry about case sensitivity, just like isEntityOnDisk worries

function rslt = isEntityOnWeb(entity)
global THEO


if iscell(entity)
  % it's a cell array, so just check existence of its first item
  entity=entity{1};
end
fullURL=entToFilename(entity,THEO.kbdir);
[s rslt] = urlread(fullURL);
