% function rslt = isEntityOnDisk(entity, <carefully 1>)
% 
% Returns 1 if entity exists on THEO.kbdir, else 0.  If carefully=1, it checks the file for
% case-sensitive match to entity name, else doesn't bother.  The default is
% carefully=THEO.caseSensitiveEntityFiles.  If the input entity is a cell array, then considers
% only its first element (i.e., considers only whether the top level entity is on disk).
%
% IMPLEMENTATION: Probably unique to Mac and Linux?  be careful under Windows because the "exist"
% function might differ.
%
% HISTORY
% 3/28/09 Tom - modified from checking THEO.entities to looking at var def in RAM, and on disk
% 5/29/09 Tom: added call to entToFilename, to support nested subdirectories
% 5/31/09 Tom: added case-sensitive test, and optional argument 'carefully'
% 9/7/09  Tom: changed default for carefully to THEO.caseSensitiveEntityFiles
% 9/8/09  Tom: extended to handle cell array input entities (e.g., {'ent','slot','subslot'})

function success = isEntityOnDisk(entity,carefully)
global THEO
if nargin<2
  carefully=THEO.caseSensitiveEntityFiles;
end
success=0;


if iscell(entity)
  % it's a cell array, so just check existence of its first item
  entity=entity{1};
end

fileName=entToFilename(entity,THEO.kbdir);

n=exist(fileName,'file');
if n==2 % a file exists on disk, but 'exist' is case insensitive
  if ~carefully
    success=1;
  else
    [directory, name, ext, versn] = fileparts(fileName);
    dirList=dir(directory); % get directory listing
    bareFileName=[entity, '.xml'];
    for k=1:length(dirList)
      if strcmp(bareFileName, dirList(k).name);
        success=1;
        return;
      end
    end
  end
end

  
%cmdStr=sprintf('exist(''%s'', ''file'');',fileName);
%success=(evalin('base',cmdStr)>0);
