% entityIsInRAM(entity)
% returns 1 if entity is already in RAM, else 0.  Entity may be a char or cell array of strings.
% If a cell array, it checks only whether the first element is in RAM (i.e., the top level entity)
%
% HISTORY:
% Created 3/28/09 by Tom

function success = isEntityInRAM(entity)
global THEO

if ischar(entity)
  entAddr=[THEO.varPrefix,entity];
else % it's a cell array of strings. use just top level entity
  entAddr=[THEO.varPrefix,entity{1}];
end

cmdStr=sprintf('exist(''%s'', ''var'');',entAddr);
success=evalin('base',cmdStr);
