% function rslt = isEntity(entity)
% 
% Returns 1 if entity exists, else 0
%
% HISTORY 
%
% 3/28/09 Tom modified from checking THEO.entities to looking at var def in RAM, and on disk
% 9/08/09 Tom added code to thoroughly handle case where input entity is complex (i.e., cell array)


function rslt = isEntity(entity)
global THEO

if isEntityInRAM(entity)
  rslt=1;
elseif THEO.readDiskKB
  if length(THEO.kbdir>=5) && strcmp('http:',THEO.kbdir(1:5))
    rslt=isEntityOnWeb(entity);
  else
    rslt=isEntityOnDisk(entity);
  end
else
  rslt=0;
end

if rslt==1 && iscell(entity)  && length(entity)>1
  % this is a non-atomic entity (e.g., {'e','s'}), so check that the subslot is also present
  for k=2:length(entity)
    if ~memberOf(entity{k}, getCachedSlots(entity(1:k-1)))
      rslt=0;
      return
    end
  end
end
