% rslt = instanceOf(item, ancestor)
% returns 1 iff ancester is in the transitive closure of generalizations of item (i.e., if it's
% an ancestor according to the generalizaitons hierarchy)
%
% HISTORY
% created 1/31/09 Tom
% 2/26/09 Tom - repaired infinite recursion bug by testing whether item='everything'
% 3/1/09 Tom - repaired bug where it would report any item is an instance of itself.
% 9/22/09 Tom - added check that item is a Theo entity, to avoid crashes

function rslt = instanceOf(item, ancestor)
% DEBUG: fprintf('instanceOf(%s,%s)...\n',item,ancestor);
rslt=0;
if isequal(item,'everything') || ~isEntity(item)
  return
end
gens=getValueBare('generalizations',item);
if ~isTheoValue(gens)
  return
end
if memberOf(ancestor, gens)
  rslt=1;
else
  for k=1:length(gens)
    rslt=instanceOf(gens{k},ancestor);
    if rslt 
      return
    end
  end
end
