% commands to initialize Matlab version of Theo.
global THEO
global theodir

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% USER MODIFIABLE REGION BEGINS HERE.  IF YOU PORT TO A NEW PLATFORM OR USER, UPDATE THIS PART OF
% THE FILE TO ADD YOUR PERSONAL INFORMATION.  YOU CAN USE userpathstr TO IDENTIFY YOUR USER NAME,
% AND ADD A NEW ELSEIF CONDITION TO COVER YOU.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% edit the following line to indicate the directory where you have places your copy of the Theo code

theodir = '/Users/tommitchell/Documents/trunk/src/matlab/Theo/';


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% END OF USER-MODIFIABLE REGION.
% Do not update below here unless you intend to change the behavior of Theo
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addpath(theodir);
addpath(fullfile( theodir, 'code'));
addpath(fullfile( theodir, 'code', 'coreTheo'));
addpath(fullfile( theodir, 'code', 'DecisionTrees'));
addpath(fullfile( theodir, 'code', 'prolog'));
addpath(fullfile( theodir, 'code', 'FOLrules'));
addpath(fullfile( theodir, 'code', 'RTW'));
addpath(fullfile( theodir, 'TheoKBs'));
addpath(fullfile( theodir, 'userKBs'));


THEO.entitiesInRAM={}; % gives the list of entities in RAM
THEO.kbdir=[fullfile(theodir, 'userKBs'), filesep];
THEO.TheoKBdir=[fullfile(theodir, 'TheoKBs'), filesep];
THEO.tmpdir=[fullfile(theodir, 'tmp'), filesep];
THEO.user='TMM';
THEO.varPrefix='THEO_';
THEO.maintainDiskKB=1; % set to 1 to maintain kb on THEO.kbdir, else 0
THEO.maintainDiskHierarchy=0; % set to 1 to maintain the index.html file using the function
                              % webdisplayHierarchy(everything)
THEO.traceGetValue=0; %set to 1 to get printouts for debuging
THEO.traceGetValueBare=0; %set to 1 to get printouts for debuging
THEO.stack={}; % if THEO.debug, then use this as stack of getValue calls
THEO.cachingOn=1; % if 1 then cache infered slot values
THEO.kbSubdirDepth=3; % states how deep the subdirs go to store kb

%% Next group controls storing/reading KB from disk
THEO.readDiskKB=1; % set to 1 to have Theo read in entities on demand from THEO.kbdir.  If you
                  % want to also reflect updates on the disk copy then also set THEO.maintainDiskKB=1
THEO.maxEntitiesInRAM=10000;   % set max number of entities to be cached in RAM when readDiskKB=1.
THEO.traceSwapInEntity=0; % set to 1 toenable screen notifaction when entities swapped in from disk.
THEO.caseSensitiveEntityFiles=0; % set to 1 to distinguish case-sensitive files. default 0 for
                                 % RTW Java compatibility.
% THEO_everything.generalizations.val={};  % define the entity 'everything'

initializeProlog  % defines global vars used by Prolog method and FOLR rule learning


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% could load the Theo KB, but since we're working off disk, allow entities to be loaded as needed

%THEO.maintainDiskHierarchy=0; % be efficient while loading kb's
%theokb  % define the standard Theo kb
%rtwkb   % load RTW ontology
%THEO.maintainDiskHierarchy=1; % default is to mirror entity updates to disk...

display(THEO);
%webdisplayHierarchy('everything');

fprintf('THEO initialized.\n');

