% Implements a simple Theo inherit (without context) method.
%
%   Example: inherit(s, {a b c d}) <- inherits value of s from
%   gens*(d), returning the first inherited value.  If there are
%   multiple generalizations, it will try them all before giving
%   up, but there is no guarantee which of the possible inherited
%   values it will return.
%
% Note this version of inheritance uses getValueBare, and not
% getValue with slot inference.
%
% Created 10/26/08 Tom
% Tom 4/29/09 added test to avoid crash when gens(everything)=novalue

function rslt = inherit(s,e)
if iscell(e)  % drop all context, use gv(s,e{end});
  e=e{end};
  v=getValue(s,e);
  if isTheoValue(v)
    rslt=v;
    return
  end
end
d=getValue('domain',s);
rslt=inheritHelper(s,e,d);



function val = inheritHelper(s,e,d)
val='NO_THEO_VALUE';
if strcmp(e,d)  % can't inherit beyond the domain(s), which is d
  return
end

gs=getValueBare('generalizations',e);
if isTheoValue(gs)
  for k=1:length(gs);
    v=getValueBare(s,gs{k});
    if isTheoValue(v)
      val=v;
      return
    end
  end

  % the immediate generalizations don't have a value, so chase up the
  % generalization hierarchy as far as the domain d.
  for k=1:length(gs);
    val=inheritHelper(s,gs{k},d);
    if isTheoValue(val)
      return
    end
  end
end

if 0  % setup for testing code...
  ce('nrOfLegs','slot');
  pv('domain','nrOfLegs','person');
  pv('nrOfValues','nrOfLegs',1);
  pv('availableMethods','nrOfLegs',{'inherit'});
  pv('nrOfLegs','person',2);
  ce('george','person');

  getValue('nrOfLegs','george');
  
end
