% [value, probability, source] = getValueKB(slot, entity)
%  Returns the value of slot of entity, using the knowledge base specified by the most recent useKB
%  command.  Also returns its probability (if one is associated with the value), and the source
%  justification for the value.  If the value is a list (which will be the case unless
%  getValue('nrOfValues',slot) is 1), then the returned probability and source are also lists
%  containing the same number of entries as the returned list of values. If probability or source are
%  unavailable, then returns -1 for their values.
%
% Examples:
%  getValueKB('homeStateOf','Bill')
%  getValueBare('confidence', {'Bill','homeStateOf'})
%
% HISTORY: 9/7/09 created by Tom
%
  
function [value, probability, source] = getValueKB(slot, entity)
global THEO
probability=-1;
source=-1;

if ~isEntity(entity)
  value='NO_THEO_VALUE';
else
  value = getValueBare(slot,entity);
  prb = getValueBare('probability', entSlot2entAddr(entity,slot));
  src = getValueBare('source', entSlot2entAddr(entity,slot));
  
  if isTheoValue(prb)
    probability=prb;
  end
  
  if isTheoValue(src)
    source=src;
  end
end
