% the basic function for retrieving slot values.  Returns the value of
% SLOT of ENTITY.  If no value is available, then it returs the
% string 'NO_THEO_VALUE'. Analogously to putValueBare, Slot must be a string.
% Entity may be a string naming a top-level entity, or it may be a
% cell array of strings representing a (sub)slot of an entity.  If the
% latter, the slot of that nested entity will be retrieved.  
%
% Examples:
%  getValueBare('homeStateOf','Bill')
%  getValueBare('temperature','Bill')
%  getValueBare('confidence', {'Bill','homeStateOf'})
%
% HISTORY: created by Tom
% 3/21/09 Tom Added useGetEntityStruct if statement, to allow using getEntityStruct instead of
%             getValueBare, but decided against using it due to 75& additional time cost.
% 3/28/09 Tom implemented THEO.readDiskKB -- COULD BE MORE EFFICIENT IF isEntityInRAM returned
%             second argument, which is the struct itself....
%
% TODO: get rid of this error by truncating strings to 63-length('THEO_')
% Warning: 'THEO_color_toners_inkcartridge_drumkit_drums_linten_printer_parts' 
% exceeds the MATLAB maximum name length of 63 characters and will be truncated to 
% 'THEO_color_toners_inkcartridge_drumkit_drums_linten_printer_par'.  In getValueBare at 35.  (FOR
%  NOW, I FIXED THIS INSIDE THE HIGHER LEVEL FNS OLputValue and OLcreateEntity)
% tic; for k=1:1000 getValueBare('specializations','everything'); end, toc;
  
function rslt = getValueBare(slot, entity)
global THEO
rslt='*noValue*';

if THEO.traceGetValueBare
  THEO.stack{end+1}={slot entity};
  fprintf('>getValueBare(%s,%s)\n',slot,value2printString(entity));
end

if THEO.readDiskKB && ~isEntityInRAM(entity) % first check whether entity is in RAM
  if ~swapInEntity(entity) % and if not, try swapping it in from disk
    fprintf('**WARNING: putValueBare cannot find %s on disk or in memory.\n',v2p(entity));
    crash;
  end
end

useGetEntityStruct=0;
if useGetEntityStruct
  % this approach has a little more overhead, but gets rid of call to evalin
  % TOO MUCH OVERHEAD!  .32 msec/getvaluebare, compared to .18msec for inline code.
  str=getEntityStruct(entSlot2entAddr(entity,slot)); 
  if isTheoValue(str) && isfield(str,'val')
    value=getfield(str,'val');
  else
    value='NO_THEO_VALUE';
  end
else
  if ischar(entity)
    slotStructAddr=[THEO.varPrefix,entity];
  else
    slotStructAddr=[THEO.varPrefix,entity{1}];
    for k=2:length(entity)
      slotStructAddr=[slotStructAddr, '.', entity{k}];
    end
  end

  slotStructAddr=[slotStructAddr, '.',slot, '.val'];

  try
    value=evalin('base', slotStructAddr);
  catch eObj
    value='NO_THEO_VALUE';
  end
end

rslt=value;
if THEO.traceGetValueBare
  THEO.stack=THEO.stack(1:end-1);
  fprintf('<getValueBare(%s,%s)=%s\n',slot,value2printString(entity),value2printString(rslt));
end  
