% level 1 getValue function.  
%
% Given input slot s and entity e, first tries to retrieve cached value of s of e.  If this fails,
% then it attempts to infer a value, using in order the inference methods listed in
% gv('availableMethods',{e,s}).  If one or more values are successfully infered and if
% THEO.cachingOn==1, then it caches the infered slot values, along with (e s 'source') whose
% value is the name of the method that infered it.  It might also store in a subslot the probability
% associated with each infered value.  Probabilities are only infered right now by the 'prolog'
% method.  They are stored int he 'probability' subslot of (e s), as a 1xn row vector of
% probabilities, where n is the number of cached values for (e s)
%
% This also supports tracing of getValue calls, if THEO.traceGetValue==1
%
% HISTORY
% created by Tom
% 3/15/09 Tom added rule and bindings to 'source' subslot when prolog used to infer value
% 3/15/09 Tom implemented whenToCache=ifValueKnown

function rslt = getValue(s,e)
global THEO
if THEO.traceGetValue
  THEO.stack{length(THEO.stack)+1}={s,e};
  fprintf('%d>getValue(%s,%s)\n',length(THEO.stack),s,value2printString(e));
end

%% get the value of s of e
rslt = getValueBare(s,e);
%if 0 && ~isTheoValue(rslt)
if ~isTheoValue(rslt)
  [rslt method probabilities methodArguments] = applyMethods(s,e);

  if THEO.cachingOn  % if caching is turned on, cache inferred value
    w2cache=getValue('whenToCache',s);
    if strcmp(w2cache,'always') || (strcmp(w2cache,'ifValueKnown') && isTheoValue(rslt))
      % cache the inferred value, source, probabilities
      putValueBare(s,e,rslt);
      if isequal(1,getValue('nrOfValues',s))
        nvals=1;
      else
        nvals=length(rslt);
      end
      source={};
      for k=1:nvals
        if length(methodArguments)>=k
          source{k}={{method methodArguments{k}}};
        else
          source{k}={method};
        end
      end
      eaddr=entSlot2entAddr(e,s);
      putValueBare('source',eaddr,source);
      if length(probabilities)>0
        putValueBare('probability',eaddr,num2cell(probabilities));
      end
    end
  end
end

if THEO.traceGetValue
  fprintf('%d<getValue(%s,%s)=%s\n',length(THEO.stack),s,value2printString(e),value2printString(rslt));
  THEO.stack=THEO.stack(1:end-1);
end  
