% [lvs ntimes] = getKnownValues(slot, <instancesToUse>)
%
% return the unique list of values found for slot in the knowledge base (lvs), and a second list of
% numbers(ntimes) where ntimes(i) tells how many times lvs(i) occurs. If second optional
% argument is given, it will use this list of entities instead of the entire KB.  Requires that
% domain(slot) be available.
%
% Currently uses getValueBare to collect the values, and ASSUMES VALUES ARE STRINGS.
%
% HISTORY:
% created 1/1/09 Tom

function [lvs ntimes] = getKnownValues(slot, varargin)
instancesToUse={};
knownVals={};
ntimes=[];

if nargin>1
  instancesToUse=varargin{1};
end
if length(instancesToUse)>0
  [lvs ntimes]=collectUniqueVals(slot,instancesToUse,knownVals,ntimes);
  return
end
  
d=getValue('domain',slot);
if ~isTheoValue(d)
  fprintf('**WARNING: you must define domain of %s ***\n',slot);
  CRASH;
end
instances={d};
[lvs ntimes]=collectUniqueVals(slot,instances,knownVals,ntimes);


function [lvs ntimes] = collectUniqueVals(slot,instances,knownVals, ntimes);
nrSlotVals = getValue('nrOfValues',slot);
% step 1, collect unique new values from instances
for k=1:length(instances)
  v=getValueBare(slot,instances{k});
  if isTheoValue(v)
    if nrSlotVals==1
      if ischar(v)&&(0==sum(find(strcmp(v,knownVals),1)))
        % v is a not-yet-observed string value for slot
        knownVals{end+1}=v;
        ntimes(end+1)=1;
      elseif ischar(v) 
        % v is already-observed, so update its count
        [r loc]=memberOf(v,knownVals);
        if r
          ntimes(loc)=1+ntimes(loc);
        else
          fprintf('why cant getKnownValues find %s in %s\n', v,v2p(knownVals));
        end
      elseif isnumeric(v)&&(0==sum(find(isequal(v,knownVals),1)))
        knownVals{end+1}=v;
        ntimes(end+1)=1;
      elseif isnumeric(v) 
        % v is already-observed number, so update its count
        [r loc]=memberOf(v,knownVals);
        if r
          ntimes(loc)=1+ntimes(loc);
        else
          fprintf('why cant getKnownValues find %s in %s\n', v,v2p(knownVals));
        end
      end
    else % multi-valued slot
      for j=1:length(v)
        if ischar(v{j})&&(0==sum(find(strcmp(v{j},knownVals),1)))
          % v{j} is not yet observed string
          knownVals{end+1}=v{j};          
          ntimes(end+1)=1;
        elseif ischar(v{j}) 
          % v{j} is already-observed string, so update its count
          [r loc]=memberOf(v{j},knownVals);
          ntimes(loc)=1+ntimes(loc);
        elseif isnumeric(v{j})&&(0==sum(find(isequal(v{j},knownVals),1)))
          % v{j} is already observed number
          knownVals{end+1}=v{j};
          ntimes(end+1)=1;
        elseif isnumeric(v{j})
          [r loc]=memberOf(v{j},knownVals);
          ntimes(loc)=1+ntimes(loc);
        end
      end
    end
  end  
end
% step 2: merge these with values of their specializations
for k=1:length(instances)
  sp=getValueBare('specializations',instances{k});
  if isTheoValue(sp)
    knownVals=collectUniqueVals(slot,sp,knownVals,ntimes);
  end
end
lvs=knownVals;
