% return a cell array containing the unique list of instances of entity.  Here an "instance" is any
% specializations* of entity that is a leaf node in the KB ontology (a leaf is an entity with no
% specializations). If ent is itself a leaf, returns the list {ent}.
%
% Example:
%   getInstances('male') 
%   returns: {bob, rob, tom, victor, will} 
%
% HISTORY:
% created 1/22/09 Tom

function leaves = getInstances(ent)
leaves={};
s=getValueBare('specializations',ent);
if ~isTheoValue(s)
  leaves={ent};
  return
else
  for k=1:length(s)
    leaves=[leaves getInstances(s{k})];
  end
end

leaves=unique(leaves);
