% createEntity, ce (entity <generalizations 'root'> <slotlist>)
% Creates a top level Theo entity, with optionally specified
% generalizations and slot values.  I.e., creates a new XML file in the
% kbdir describing this entity.
% 
% Returns the string name of the created file, or 0 if failure 
%
% EXAMPLE 1. create the entity DAVE with generalizations={'person'} and age=27.
% Also adds DAVE to SPECIALIZATIONS of PERSON
%
%   ce('dave' {'person'} {'age', 27; 'employer','CMU'}): 
%
%
% EXAMPLE 2. create the entity MALE, with GENERALIZATIONS=(PERSON) and
% SPECIALIZATIONS=(DAVE JOE).  In case DAVE and JOE used to be
% specializations of PERSON, they are moved to the appropriate place in
% the hierarchy.
% 
%   ce('male' {'person'} {'specializations', {'dave' 'joe'}}) : 
%

function theStruct = getEntity(entity)
global THEO
rslt=0;
efilename=[THEO.kbdir,entity,'.xml'];

% PARSEXML Convert XML file to a MATLAB structure.
try
   tree = xmlread(efilename);
catch
   error('Failed to read XML file %s.',efilename);
end

% Recurse over child nodes. This could run into problems 
% with very deeply nested trees.
try
   theStruct = parseChildNodes(tree);
catch
   error('Unable to parse XML file %s.');
end


% ----- Subfunction PARSECHILDNODES -----
function children = parseChildNodes(theNode)
% Recurse over node children.
children = [];
if theNode.hasChildNodes
   childNodes = theNode.getChildNodes;
   numChildNodes = childNodes.getLength;
   allocCell = cell(1, numChildNodes);

   children = struct(             ...
      'Name', allocCell, 'Attributes', allocCell,    ...
      'Data', allocCell, 'Children', allocCell);

    for count = 1:numChildNodes
        theChild = childNodes.item(count-1);
        children(count) = makeStructFromNode(theChild);
    end
end

% ----- Subfunction MAKESTRUCTFROMNODE -----
function nodeStruct = makeStructFromNode(theNode)
% Create structure of node info.

nodeStruct = struct(                        ...
   'Name', char(theNode.getNodeName),       ...
   'Attributes', parseAttributes(theNode),  ...
   'Data', '',                              ...
   'Children', parseChildNodes(theNode));

if any(strcmp(methods(theNode), 'getData'))
   nodeStruct.Data = char(theNode.getData); 
else
   nodeStruct.Data = '';
end

% ----- Subfunction PARSEATTRIBUTES -----
function attributes = parseAttributes(theNode)
% Create attributes structure.

attributes = [];
if theNode.hasAttributes
   theAttributes = theNode.getAttributes;
   numAttributes = theAttributes.getLength;
   allocCell = cell(1, numAttributes);
   attributes = struct('Name', allocCell, 'Value', ...
                       allocCell);

   for count = 1:numAttributes
      attrib = theAttributes.item(count-1);
      attributes(count).Name = char(attrib.getName);
      attributes(count).Value = char(attrib.getValue);
   end
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Subfunction to create sting with spaces to store list
function rsltStr=cellStrings2spacedStrings(cellstrs)
rsltStr=cellstrs{1};
for k=2:length(cellstrs)
  rsltStr=[rsltStr,' ',cellstrs{k}];
end
