% rslt = getEntityStruct(entity)
%
% Low level function tied to matlab implmentation.  Return the matlab struct that represents input
% ENTITY.  If there is no such entity struct, returns 'NO_THEO_VALUE'
%
% Note input ENTITY may be either a string (in which case it refers to a top-level entity, or a cell
% array of strings (in which case it refers to an embedded entity in the context of some other top
% level entity).
%
% Example:
%  getEntityStruct('Bill')
%  getEntityStruct({'Bill','wife'})
%
% HISTORY:
% Created 10/21/2008 - Tom
% 3/28/09 Tom - modified to implement THEO.readDiskKB
% 9/9/09  Tom - modified to return 'NO_THEO_VALUE' if entity doesn't exist

function rslt = getEntityStruct(entity)
global THEO
rslt={};

% first check whether entity is in RAM, and if not try swapping it in.
if THEO.readDiskKB && ~isEntityInRAM(entity) && ~swapInEntity(entity) 
%  fprintf('WARNING: getEntityStruct cannot find %s in memory or offline.\n',v2p(entity));
  rslt='NO_THEO_VALUE';
  return
end

if ischar(entity)
  entStructAddr=[THEO.varPrefix,entity];
elseif iscell(entity)
  entStructAddr=[THEO.varPrefix,entity{1}];
  for k=2:length(entity)
    entStructAddr=[entStructAddr, '.', entity{k}];
  end
else
  fprintf('***THEO getEntityStruct: input arg %s not an entity\n',entity);
end

try
  value=evalin('base', entStructAddr);
catch eObj
  value='NO_THEO_VALUE';
end
  
rslt=value;
  
