% rslt = getEntitiesWithSlotValue(slot, <val>)
%
% Returns the list of all KB entities that contain "val" as a value for "slot".  If only the first
% input argument is provided, then it returns all KB entities that contain any value for "slot".  It
% handles cases where nrOfValues = 1, and nrOfValues=any (in which case it checks the list of values
% for val).
%
% Warning: this requires time linear in the number of entities in the domain of slot
%
% Examples:
%
%   get all entities for which slot 'friendly' has value 'yes'
%   getEntitiesWithSlotValue('friendly','yes');   
%
%   get all entities for which slot 'friendly' has any known value
%   getEntitiesWithSlotValue('friendly');   
%
%
% HISTORY:
% Created Tom 9/13/09
% 9/17/09 Tom: added error check that input slot exists
% 9/17/09 Tom: generalized to make second input argument optional

function rslt = getEntitiesWithSlotValue(slot, val)
global THEO
global TMP
TMP={};
rslt={};

if ~isEntity(slot) 
  return
end


domain=getValue('domain',slot);
if ~isTheoValue(domain)
  fprintf('WARNING from getEntitiesWithSlotValue: domain(%s) is undefined! ***\n',slot);
  return
end

if nargin==2
  captureValReferences = @(d) captureSlotValReferences(d,slot,val);
  mapDescendants(domain, captureValReferences);
  rslt=TMP;
elseif nargin==1
  captureEntsWithValue = @(d) captureEntsWithAnyValue(d,slot);
  mapDescendants(domain, captureEntsWithValue);
  rslt=TMP;
end
clear TMP;



function [] = captureSlotValReferences(d,s,e)
global TMP
debug=0;
if debug
  fprintf('captureSlotValReferences(%s,%s,%s)\n',d,s,e);
end

vs=getValueBare(s,d);
nv=getValue('nrOfValues',s);
if isTheoValue(vs) && isTheoValue(nv)
  if isequal(nv,1)
    if isequal(vs,e)
      TMP{end+1}=d;
    end
  else
    if ismember(e,vs)
      TMP{end+1}=d;
    end
  end
end



function [] = captureEntsWithAnyValue(d,s)
global TMP
debug=0;
if debug
  fprintf('captureEntsWithAnyValue(%s,%s)\n',d,s);
end

if isTheoValue(getValueBare(s,d))
      TMP{end+1}=d;
end
