% Returns the list of cached slots and subslots of ENTITY, as a 1xn cell array of cell arrays, of
% the form { {subsubslot {entity slot subslot ...}} ...}.  In other words, each item in the returned
% list gives the name of a sub...subslot of some entity address inside the input entity.  Only include
%
% Example:
%  getCachedSlotsSubslots('Bill')
%  getCachedSlotsSubslots({'Bill', 'wife'})
%
% HISTORY:
% Created 6/17/09 - Tom - copy and edit of getCachedSlots.m


function rslt = getCachedSlotsSubslots(entity)
global THEO
rslt={};
slotList=fieldnames(getEntityStruct(entity));
for k=1:length(slotList)
  if ~strcmp('val',slotList{k});
    rslt{end+1}={slotList{k}, entity};
    
    % and if there are subslots, call recursively
    subRslt = getCachedSlotsSubslots(entSlot2entAddr(entity,slotList{k}));
    rslt = [rslt subRslt];
  end
end
