% this demonstrates/tests the code for maintaining sources and probabilities for slot values
% tests correctly 8/24/09.  Tom

initializeTheo
THEO.readDiskKB=0;
THEO.maintainDiskKB=0;
THEO.maintainDiskHierarchy=0; % make it efficient

theokb  % load theo's system kb
pfamilykb  % load the family kb

prh('everything');  % print the hierarchy of entities under 'everything'
pre('tom'); % print the entity 'tom'

deleteSlotBare('parents','tom');
pv('mother','tom','louise');
gv('parents','tom'); % this should infer both bob and louise as parents
pre('tom',6);

% test that removeValue kills off the appropriate source and probability subslots
removeValue('parents','tom','bob');
pre('tom',6);
removeValue('parents','tom','louise');
pre('tom',6);

% show how putValueC handles multiple candidate values when nrOfValues=1
deleteSlot('spouse','tom')
putValue('spouse','tom','joan'); 
putValueC('spouse','tom','bob', 1, {'manual' 0.1}, 0.1);
pre('tom',6);

% and it also creates as needed the source and probability subslots.
putValueC('father','tom','bob', 1, {'manual' 0.1}, 0.1);
pre('tom',7);
putValueC('father','tom','louise', 1, {'manual2' 0.2}, 0.2);
pre('tom',7);

% and here are example calls to the OL API functions
ce('country_of','slot'); pv('nrOfValues','country_of',1); pv('domain','country_of','location');
pre('country_of',6);

% note OLcreateEntity and OLputValue are functions in RTW for accessing Theo in a way that RTW wants
% to do.  In particular, both functions take string arguments and shift them to lower case to define
% the entity (e.g., 'Pittsburgh' will become the entity named 'pittsburgh').  Also, if you create
% the same entity twice with OLcreateEntity, you end up with one entity with both sets of
% information.  Similarly, two calls to OLputValue for the same slot will result in both values
% being added as candidate values.
OLcreateEntity('Pittsburgh','location', 1.0, {'OLversion1' '2009/02/05-16:36:40' 'ajc'})
OLputValue('country_of','Pittsburgh','U.S.A.', .9,  {'OLversion1' 'ajc'})
pre('pittsburgh',5);


% pittsburgh:
%  generalizations = {location} 
%    source = {{{OLversion1, 2009/02/05-16:36:40, ajc} } } 
%    probability = {0.9} 
%  literalString = {Pittsburgh} 
%  country_of = u_s_a_
%    source = {{{OLversion1, ajc} } } 
%    probability = {0.9} 

% note OLputValue doesn't overwrite the value -- it keeps the old value around as a candidate value
OLputValue('country_of','Pittsburgh','USA', .91,  {'OLversion1.1' 'ajc'})
% similarly, OLcreateEntity doesn't erase old entity definition, it just adds a new
% generalization to the old entity
OLcreateEntity('Pittsburgh','location', 1.0, {'OLversion1' '2009/02/05-16:36:40' 'ajc'})
%pre('Pittsburgh',8);
OLcreateEntity('Pittsburgh','city', 1.0, {'OLversion2' '2009/02/05-16:36:40' 'ajc'})
pre('pittsburgh',8);

%Pittsburgh:
%  literalString = {Pittsburgh} 
%  country_of = USA
%    source = {{{mostRecentCandidateValue, 0.91} , {OLversion1.1, ajc} } } 
%    probability = {0.91} 
%    candidateValues = {U.S.A., USA} 
%      source = {{{OLversion1, ajc} } , {{OLversion1.1, ajc} } } 
%      probability = {0.9, 0.91} 
%  generalizations = {city} 
%    source = {{{OLversion2, 2009/02/05-16:36:40, ajc} } } 
%    probability = {1} 


tic;
OLputValue('country_of','Pittsburgh','USA', .91,  {'OLversion1.1' 'ajc'});
OLcreateEntity('Pittsburgh','location', 1.0, {'OLversion1' '2009/02/05-16:36:40' 'ajc'});
OLcreateEntity('Pittsburgh','city', 1.0, {'OLversion2' '2009/02/05-16:36:40' 'ajc'});
toc


