% filename = entToFilename(entity, kbdir, <depth>, <caseSensitiveEntityFiles>)
%
% Returns full filename or URL at which entity is stored.  Uses optional input 'depth' (default =
% THEO.kbSubdirDepth) to decide how many subdirectories deep to store the entity.  Uses optional
% input 'caseSensitiveEntityFiles' (default = THEO.caseSensitiveEntityFiles) to determine whether to
% use all lowercase filename.  Note it uses lower case letters, single digits, and the string
% 'blank' as subdirectory names.
%
% Example: entToFilename('NELLstatic', THEO.kbdir, 3) 
%   returns /Users/tommitchell/Documents/trunk/data/initial_kb/n/e/l/nellstatic.xml
%
% Example: entToFilename('NELLstatic', 'http://rtw.ml.cmu.edu/sslnlp09/', 1, 0) 
%   returns http://rtw.ml.cmu.edu/sslnlp09/n/nellstatic.xml
%
% HISTORY
% Created 4/9/2009 by Tom, copy and edit of loadEntity.m
% 4/26/09 Tom: added trimming of whitespace from begin and end of entity names
% 5/22/09 Tom: added subdirectory structure.
% 7/07/09 Andy: changed entity name to lowercase.
% 9/07/09 Tom: made choice to use lowercase depend on global THEO.caseSensitiveEntityFiles
% 9/08/09 Tom: added optional argument caseSensitiveEntityFiles

function filename = entToFilename(entity, kbdir, depth,caseSensitiveEntityFiles)
global THEO

if nargin<3
  depth=THEO.kbSubdirDepth;
end
if nargin<4
  caseSensitiveEntityFiles=THEO.caseSensitiveEntityFiles;
end

DEBUG=0;
if DEBUG
  fprintf('entToFilename(%s,%s,%s) \n',v2p(entity),v2p(kbdir),v2p(depth));
end


l=length(entity);
dir=kbdir;
for d=1:depth
  if l>=d
    dir=[dir,lower(entity(d)),filesep];
  else
    dir=[dir,'blank',filesep];
  end
end

if ~caseSensitiveEntityFiles
  entity=lower(entity);
end


%% Have to do this because you cannot create files on Windows that have base name "aux", "prn",
% "con", or "nul"
if strcmp(lower(entity),'aux') || strcmp(lower(entity),'prn') || strcmp(lower(entity),'con') || strcmp(lower(entity),'nul')
  entity=['___', entity];
end

filename=[dir,entity,'.xml'];
