% a script to initialize Theo to an initial KB directory, and to create an executable file of
% putValue and createEntity commands which can be used to recreate the KB.

% uncomment next two lines if you want to use Theo_working instead of Theo
%rmpath '/Users/tommitchell/Documents/MATLAB/Theo/code/coreTheo'
%addpath '/Users/tommitchell/Documents/MATLAB/Theo_working/code/coreTheo'

% WARNING : THIS INCLUDES ALL ENTITIES IN MEMORY AND ON DISK.  START WITH A CLEAN MATLAB SESSION!

% timing: reads in about 30 entities/second when THEO.readDiskKB=1

KBdir = 'c:/dev/OntologyLearner/data/initial_kb2/'
%KBdir = '/Users/tommitchell/Documents/trunk/data/initial_kb/'
KBoutfile = '/Users/tommitchell/Documents/trunk/data/initial_kb_matlabCommands.m'

initializeTheo
useKB(KBdir);
THEO.maintainDiskKB=0; % don't update the files on KBdir

entity='everything';

createKB=0;
if createKB
  if exist(KBoutfile)==2 
    delete(KBoutfile);
  end
  % following reads in each entity and adds commands to KBoutfile
  KBdirToMatlabKBfile(entity,KBdir,KBoutfile);

else
  % alternatively, following loads the KB
  THEO.readDiskKB=0; 
  %  KBoutfile % must be on matlab path
  addpath 'c:/dev/OntologyLearner/data/'
  initial_kb_matlabCommands
  cats
  rels
  %  initial_kb_extentions
  %  matlab_seed_theocommands
  
end

%%% now edit the KB initialRTWkbUpdates.m

saveTheKB=1
if saveTheKB
  newKBdir='c:/dev/OntologyLearner/data/initial_kb_6_30_09/'
  saveKB('everything',newKBdir);
%  webdisplayHierarchy('everything',0,{'seedInstances','seedExtractionPatterns','knownNegatives','known_negatives'},[newKBdir,'index.html']);
  webdisplayHierarchy('everything',0,{'seedInstances','knownNegatives','known_negatives'},[newKBdir,'index.html']);
end
