% here is a demo of simple Theo.  It demonstrates:
%
% 1. how to create and edit entities
% 2. how to save them to disk
% 3. how to browse the saved knowledge base
%


addpath '/Users/tommitchell/Documents/MATLAB/inramTheo/'
%cd '/Users/tommitchell/Documents/MATLAB/inramTheo/userKBs/'


% load/initialize Theo
initializeTheo
THEO.maintainDiskKB=0;
THEO.readDiskKB=0;
theokb

% create a new entity, organization, declaring it a specialization
% of the ontology node 'everything'
ce('organization','everything');

% similarly, create some specializations of organization
% Note: entity names are strings and must NOT contain spaces
ce('university','organization');
ce('company','organization');
ce('government','organization');
ce('nonprofit','company');
ce('CarnegieMellon','university');
ce('Microsoft', 'company');
ce('WYEP','nonprofit');

% give some slot values to these.  Use putValue(slot,entity,value), or
% its abbreviation "pv". 
pv('homeCity','CarnegieMellon','pittsburgh');
pv('presidentOf','CarnegieMellon','JaredCohen');

% if a slot can have multiple values, then use
% addValue(slot,entity,value), or its abbreviation
% av(slot,entity,value), to add one new value at a time
av('studentsOf','CarnegieMellon','EdithLaw');
av('studentsOf','CarnegieMellon','JustinBetteridge');
av('studentsOf','CarnegieMellon','AndyCarlson');
av('studentsOf','CarnegieMellon','SophieWang');
av('facultyOf','CarnegieMellon','EstevamHruschka');
av('facultyOf','CarnegieMellon','TomMitchell');

ce('JaredCohen','person');
ce('JustinBetteridge','person');
ce('AndyCarlson','person',{'organizationOf','CarnegieMellon'});
ce('SophieWang','person',{'organizationOf','CarnegieMellon'});
ce('EstevamHruschka','person',{'organizationOf','CarnegieMellon'});
ce('SophieWang','person',{'organizationOf','CarnegieMellon'});
ce('EdithLaw','person',{'organizationOf','CarnegieMellon'});
ce('TomMitchell','person',{'organizationOf','CarnegieMellon'});


% examine the knowledge base
prh('everything','all');

% write out all of the Theo entities to disk in xml format
for k=1:length(THEO.entities)
  saveEntity(THEO.entitiesInRAM{k});
end

% create a browsable webpage showing the ontology heirarchy, and which
% links to all of the xml descriptions.  The arguments tell it to use
% the entity 'everything' as the root of the hierarchy, to store this
% on the webpage 'index.html', and to include display of 'all' slot
% values.
webdisplayHierarchy('everything',0,'index.html','all');
