% the basic function for deleting slot values.  Returns the name of
% the slot if successful, else zero.  If no value exists, it does
% nothing and reports success.  Slot must be a string.  Entity may be
% a string naming a top-level entity, or it may be a cell array of
% strings representing a (sub)slot of an entity.  If the latter, the
% slot of that nested entity will be deleted.
%
% Examples:
%  deleteValueBare('homeStateOf','Bill')
%  deleteValueBare('confidence', {'Bill','homeStateOf'})
%
% KNOWN BUGS: DOESN'T WORK BECAUSE RMFIELD DOESN'T REALLY GET RID
% OF SUBSUBFIELDS.  INSTEAD IT LEAVES BEHIND A "1X1 struct array
% with no fields".   FIX THIS...

function rslt = deleteValueBare(slot, entity)
global THEO
rslt=0;

if ischar(entity)
  slotStructAddr=[THEO.varPrefix,entity];
else
  slotStructAddr=[THEO.varPrefix,entity{1}];
  for k=2:length(entity)
    slotStructAddr=[slotStructAddr, '.', entity{k}]
  end
end
slotStructAddr=[slotStructAddr, '.',slot]

cmdStr=['rmfield(',slotStructAddr,',''val'')']

try
  rmrslt=evalin('base', cmdStr);
catch eObj
  % don't worry, be happy (it's already deleted)
end
% DEBUG PRINT STATEMENTS
display(slot);
display(slotStructAddr);
display(cmdStr);
display(rmrslt);

rslt=slot;  

  
