% the basic function for deleting slot values.  Returns the name of
% the slot if successful, else zero.  If no value exists, it does
% nothing and reports success.  Slot must be a string.  Entity may be
% a string naming a top-level entity, or it may be a cell array of
% strings representing a (sub)slot of an entity.  If the latter, the
% slot of that nested entity will be deleted.  
%
% Note that if deleting the slot's value results in a totally empty
% slot with no subslots or value, then the slot itself is also deleted
% by calling deleteSlotBare.
%
% Examples:
%  deleteValueBare('homeStateOf','Bill')
%  deleteValueBare('confidence', {'Bill','homeStateOf'})
%
% Implementation hints: this is a bit more complicated than I wish
% because the Matlab function rmfield() doesn't really get rid of
% subsubfields.  instead it leaves behind a "1x1 struct array with no
% fields".  Beware of this if you edit this code.
%
% HISTORY:
% Created 12/08 Tom
% 2/23/09 Tom added isTheoValue test to avoid needless work
% 3/14/09 Tom moved the empty slot structure test inside the 'try' construct

function rslt = deleteValueBare(slot, entity)
global THEO
rslt=0;
emptyStruct=struct; % a "1x1 struct array with no fields"
if THEO.readDiskKB && ~isEntityInRAM(entity) % first check whether entity is in RAM
  if ~swapInEntity(entity) % and if not, try swapping it in from disk
    fprintf('**WARNING: putValueBare cannot find %s on disk or in memory.\n',v2p(entity));
    crash;
  end
end

if ischar(entity)
  slotStructAddr=[THEO.varPrefix,entity];
else
  slotStructAddr=[THEO.varPrefix,entity{1}];
  for k=2:length(entity)
    slotStructAddr=[slotStructAddr, '.', entity{k}]
  end
end
slotStructAddr=[slotStructAddr, '.',slot];

if isTheoValue(getValueBare(slot,entity))
  cmdStr=[slotStructAddr,'=rmfield(',slotStructAddr,',''val'');'];
  try
    evalin('base', cmdStr);
    
    rmrslt= evalin('base',slotStructAddr);
    if (isequal(emptyStruct,rmrslt) || isempty(rmrslt))
      % this has left us an empty struct for the slot because it originally
      % had no fields other than a 'val'.  So we must now delete the
      % entire slot.
      deleteSlotBare(slot,entity);
    end
  catch eObj
    % don't worry, be happy (it's already deleted)
  end
end


rslt=slot;  
