% deleteValue(slot, entity)
%
% Delete the entire value of slot of entity.  Returns the name of the slot if successful, else zero.
% If no value exists, it does nothing and reports success.  Slot must be a string.  Entity may be a
% string naming a top-level entity, or it may be a cell array of strings representing a (sub)slot of
% an entity.  If the latter, the slot of that nested entity will be deleted.
%
% Note that if deleting the slot's value results in a totally empty slot with no subslots or value,
% then the slot itself is also deleted by calling deleteSlotBare.
%
% Examples:
%  deleteValue('homeStateOf','Bill')
%  deleteValue('confidence', {'Bill','homeStateOf'})
%
% Implementation hints: this is a bit more complicated than I wish because the Matlab function
% rmfield() doesn't really get rid of subsubfields.  instead it leaves behind a "1x1 struct array
% with no fields".  Beware of this if you edit this code.
%
% HISTORY:
% Created 12/08 Tom

function rslt = deleteValue(slot, entity)
global THEO
rslt=0;
brslt=deleteValueBare(slot,entity);

if ischar(brslt) % success, so 
  rslt=brslt;
  se=entSlot2entAddr(entity,slot); 
  if isTheoValue(getValueBare('source',se))
    deleteSlotBare('source',se);
  end
  if isTheoValue(getValueBare('probability',se))
    deleteSlotBare('probability',se);
  end
end
