% The basic function for deleting entire slots or subslots.  Deletes
% the value of the slot, PLUS ALL OF ITS SUBSLOTS, and the entire
% structure representing the slot. This returns the name of the slot
% if successful, else zero.  If no value exists, it does nothing and
% reports success.  Slot must be a string.  Entity may be a string
% naming a top-level entity, or it may be a cell array of strings
% representing a (sub)slot of an entity.  If the latter, the slot of
% that nested entity will be deleted.
%
% Examples:
%  deleteValueBare('homeStateOf','Bill')
%  deleteValueBare('confidence', {'Bill','homeStateOf'})
%
% If you wish to just delete the slot value, you should use the
% function deleteValue instead of this function.

function rslt = deleteSlotBare(slot, entity)
%%fprintf('deleteSlotBare(%s,%s)\n',slot, value2printString(entity));
global THEO
rslt=0;

if THEO.readDiskKB && ~isEntityInRAM(entity) % first check whether entity is in RAM
  if ~swapInEntity(entity) % and if not, try swapping it in from disk
    fprintf('**WARNING: deleteSlotBare cannot find %s on disk or in memory.\n',v2p(entity));
    crash;
  end
end

if ischar(entity)
  slotStructAddr=[THEO.varPrefix,entity];
else
  slotStructAddr=[THEO.varPrefix,entity{1}];
  for k=2:length(entity)
    slotStructAddr=[slotStructAddr, '.', entity{k}];
  end
end

cmdStr=[slotStructAddr,'=rmfield(',slotStructAddr,',''',slot,''');'];

try
  evalin('base', cmdStr);
catch eObj
  % don't worry, be happy (it's already deleted)
end

% finally, let's check whether deleting this slot left an empty
% superslot, and if so, delete that as well.
if iscell(entity) && length(entity)>1 % we just deleted a subslot,
                                      % not top level slot
  emptyStruct=struct; % a "1x1 struct array with no fields"
  rmrslt= evalin('base',slotStructAddr);
  if isequal(emptyStruct,rmrslt)
    % deleteing slot from this entity this has left an empty
    % struct, indicating that the superslot should also be deleted
    slt=entity{end};
    if length(entity)==2
      ent=entity{1};
    else
      ent=entity(1:(end-1));
    end
    deleteSlotBare(slt,ent);
  end
end

%%%%%%%%%%%% 
%if necessary, swap out to disk
if THEO.maintainDiskKB
  if iscell(entity)
    saveEntity(entity{1})
  else
  saveEntity(entity);
  end
end
if THEO.maintainDiskHierarchy
  webdisplayHierarchy('everything',0,'all');
end
%%%%%%%%%%%%%

rslt=slot;  

