% rslt = deleteSlot(slot, entity)
%
% The basic function for deleting entire slots or subslots.  Deletes the value of the slot, PLUS ALL
% OF ITS SUBSLOTS, and the entire structure representing the slot. This returns the name of the slot
% if successful, else zero.  If no value exists, it does nothing and reports success.  Slot must be
% a string.  Entity may be a string naming a top-level entity, or it may be a cell array of strings
% representing a (sub)slot of an entity.  If the latter, the slot of that nested entity will be
% deleted.
%
% Examples:
%  deleteSlot('homeStateOf','Bill')
%  deleteSlot('confidence', {'Bill','homeStateOf'})
%
% If you wish to just delete the slot value, you should use the function deleteValue instead of this
% function.  If you wish to delete just one value of a slot, use removeValue.
%
% HISTORY - created by Tom

function rslt = deleteSlot(slot, entity)
%%fprintf('deleteSlotBare(%s,%s)\n',slot, value2printString(entity));
global THEO
rslt=deleteSlotBare(slot,entity);
