%  [] = createSlotSP(s,e,createSource,createProbability)
%
%  This function creates the 'source' and 'probability' subslots of slot s of entity e.  In
%  particular, if createSource=1 and the 'source' subslot doesn't exist, then it is created and
%  assigned a source of {{{'unknown'}}}.  If createSource=0, source will not be created.  Similarly,
%  if createProbability=1 and 'probability' subslot doesn't exist, it is created and assigned the
%  value {'unknown'}.
%
% HISTORY:
% Created 2/23/2009 -Tom 

function [] = createSlotSP(s,e,createSource,createProbability)
global THEO
esAddr=entSlot2entAddr(e,s);
if createSource
  oldS=getValueBare('source',esAddr);
  if ~isTheoValue(oldS) % if it doesn't already exist, then create
    addValue('source',esAddr,{{'unknown'}});
  end
end
if createProbability
  oldS=getValueBare('probability',esAddr);
  if ~isTheoValue(oldS)
    addValue('probability',esAddr,'unknown');
  end
end
