% create slot, its value, and its subslots, recursively
function [] = createSlotBareFromDOMnode(node,entityName)
global THEO
debug=0;
% following are Java-defined integers for node types
textNode=3;
element=1;

nodeChildren = node.getChildNodes;
for k=1:(nodeChildren.getLength-1)
  if (nodeChildren.item(k).getNodeType == element) 
    % only process element nodes - others are empty
    child=nodeChildren.item(k);
    tagName= char(child.getTagName);
    if strcmp(tagName,'slot')
      createSlotBareFromDOMnode(child, entSlot2entAddr(entityName, slotName));
    elseif strcmp(tagName,'name')
      slotName= char(child.getFirstChild.getData);
    elseif strcmp(tagName, 'val')
      valNode=child.getFirstChild;
      val = createMatlabTypeFromXMLtype(valNode);  %%%%%%% THE BUG IN valNode
      if debug 
        fprintf('pv(%s,%s,%s)\n', slotName, value2printString(entityName), value2printString(val));
      end
      putValueBareBare(slotName, entityName, val);
    end
  end
end
