% rslt = createMatlabTypeFromXMLtype(valNode)
% create slot, its value, and its subslots, recursively
%
% HISTORY: created by Tom
% 3/28/09 Tom - upgraded to cover 'in' xml tag for integer
% 5/29/09 Tom - upgraded to treat <val></val> as the empty list <val><l></l></val>

function rslt = createMatlabTypeFromXMLtype(valNode)
global THEO
debug=0;
if debug
  THEO.debug=valNode;
  display(valNode);
%  fprintf('%s',v2p(valNode));
end

% first handle the very special case where valNode comes from the empty <val></val>
if isequal([],valNode)
  rslt={};
  return;
end

% following are Java-defined integers for node types
textNode=3;
element=1;

nodeType=valNode.getNodeType;
if nodeType==textNode
  if valNode.getData.compareTo('');
    rslt='';
  else
    rslt=char(valNode.getData);
  end
elseif nodeType==element
  if strcmp(char(valNode.getTagName),'s') % it's a string
    rslt=char(valNode.getFirstChild.getData);
  elseif strcmp(char(valNode.getTagName),'r') % it's a real number
    numStr=char(valNode.getFirstChild.getData);
    rslt=sscanf(numStr,'%f');
  elseif strcmp(char(valNode.getTagName),'in') % it's an integer
    numStr=char(valNode.getFirstChild.getData);
    rslt=sscanf(numStr,'%d');
  elseif strcmp(char(valNode.getTagName),'l') % it's a list
    rslt={};
    for k=0:valNode.getChildNodes.getLength-1
      v = createMatlabTypeFromXMLtype(valNode.getChildNodes.item(k));
      if ~(strcmp(v,''))
        rslt{length(rslt)+1}=v;
      end
    end
  end
end

if debug
  THEO.debugPrevious=valNode;
end
  

