% createEntityBare(entity) 
%
% Creates a top level Theo entity data structure in RAM only and adds it to THEO.entitiesInRAM. If
% an entity with this name already exists, it overwrites it.
%
% NOTE: You probably want to use createEntity, not createEntityBare, since it takes care of
% maintaining generalizations and specializations, and interfacing with the disk copy of the KB 
% 
% Returns the string name of the created entity, or 0 if failure 
%
% EXAMPLE 1. create the entity DAVE, only in RAM
%
%   ce('dave'): 
%
% HISTORY: created 4/9/09 Tom
% 5/31/09 Tom: updated to use THEO.entitiesInRAM instead of outdated THEO.entities
% 6/25/09 Tom: corrected condition under which entity is added to THEO.entitiesInRAM

function rslt = createEntityBare(entity)
global THEO
rslt=0;

% define a new variable in the global workspace, called THEO_<entityname>, eg., THEO_joe, and
% assigns its slots, subslots, etc. as a struct
entityVarName=sprintf('%s%s', THEO.varPrefix, entity); 
entityStruc.generalizations.val='NO_THEO_VALUE';
assignin('base',entityVarName,entityStruc);

if ~memberOf(entity,THEO.entitiesInRAM)
  THEO.entitiesInRAM{end+1}=entity;
end

rslt=entity;
