% createEntity, ce (entity <generalizations 'root'> <slotlist>) Creates a top level Theo entity,
% with optionally specified generalizations and slot values.  I.e., creates a new XML file in the
% kbdir describing this entity.  If an entity with this name already exists, it returns a value
% of 0 without creating the entity.
% 
% Returns the string name of the created entity, or 0 if failure 
%
% EXAMPLE 1. create the entity DAVE with generalizations={'male',
% 'professor'} and age=27.  Also adds DAVE to SPECIALIZATIONS of
% 'male' and 'professor' as a side effect.
%
%   ce('dave', {'male', 'professor'}, {'age', 27; 'employer','CMU'}): 
%
%
% EXAMPLE 2. create the entity MALE, with GENERALIZATIONS=(PERSON) and
% SPECIALIZATIONS=(DAVE JOE).  In case DAVE and JOE used to be
% specializations of PERSON, they are moved to the appropriate place
% in the hierarchy.  Note since there is just one generalization,
% there's no need to place that input argument it in a cell array
% (though it's acceptable to do so).
% 
%   ce('male', 'person' {'specializations', {'dave' 'joe'}}) : 
%
% HISTORY:
% 6/2/2009 Tom: changed default generalizations from {everything} to {}

function rslt = createEntity(entity, varargin)
global THEO
rslt=0;

if isEntity(entity)
  return
end

%%%%% process varargin
if (nargin>1) 
  generalizations=varargin{1};
  if ~iscell(generalizations) % for convenience, allow string or
                              % cell with one string
    generalizations={generalizations};
  end
else
%  generalizations={'everything'};
  generalizations={};
end

%%%%%% 1. create entity data structure
entityStruc.generalizations.val=generalizations;
THEO.entitiesInRAM{end+1}=entity;
% next 2 lines define a new variable in the global workspace, called
% THEO_<entityname>, eg., THEO_joe, and assigns its slots, subslots,
% etc. as a struct
entityVarName=sprintf('%s%s', THEO.varPrefix, entity); 
assignin('base',entityVarName,entityStruc);


%%%%%% 2. add entity to specializations of its generalizations
for k=1:length(generalizations)
  addValue1('specializations',generalizations{k},entity);
end

if (nargin>2)   %
  slotvals=varargin{2};
  for k=1:size(slotvals,1)
    slot=slotvals{k,1};
    val=slotvals{k,2};
    if ~ischar(val)  % cover case where input was a scalar, turned
                     % into array with one element...
      val=val(1);
    end
    putValue(slot,entity,val);
  end
end

rslt=entity;


if THEO.maintainDiskKB
  saveEntity(entity);
end
if THEO.maintainDiskHierarchy
  webdisplayHierarchy('everything',0,'all');
end
