% first version of slot inference.  This should be extended to take
% union of inferred values if the arity of the slot is not 1.
%
% Returns
% rslt: the inferred slot value.
% method: name of the method used to infer the value (e.g., 'inherit')
% probabilities: a row vector of n probabilities for the n values in rslt.  At present, only
% prolog method provides these.  For other methods, the empty vector [] is returned.
%
% Created  10/26/08  Tom
% 1/22/09 Tom added Prolog method.  Need to allow it to return probabilities
% 3/15/09 Tom added returned value methodArguments (initially used only by prolog method)

function [rslt method probabilities methodArguments] = applyMethods(s,e)
rslt='NO_THEO_VALUE';
method={};
probabilities=[];
methodArguments={};

%ams=getValue('availableMethods',{e,s});
ams=getValue('availableMethods', s);
for k=1:length(ams)
  switch ams{k}
   case { 'inherit' }
    fh = @inherit;
   case { 'defaultValue' }
    fh = @defaultValue;
   case { 'dropAllContext' }
    fh = @dropAllContext;
   case { 'prolog' }
    fh = @prolog;
  end
  
  if strcmp(ams{k},'prolog')
    % prolog method returns a list of probabilities - one per item in rslt, plus associated rulebindings
    [rslt probabilities methodArguments] = fh(s,e);
  else 
    rslt= fh(s,e);
  end
  
  if isTheoValue(rslt)
    method=ams{k};
    return
  end
end
