%  [rslt index] = addValueBare(slot, entity, value)
%
% The basic function for adding a value to a multi-valued slot.  Adds VALUE to the list (cell array)
% of values for SLOT of ENTITY.  Slot must be a string.  Entity may be a string naming a top-level
% entity, or it may be a cell array of strings representing a (sub)slot of an entity.  If the
% latter, the slot of that nested entity will be set.  VALUE may be any data type.
%
% Note this function does NOT maintain generalizations/specializations pairs, use addValue to do that.
%
% Returns: 
% rslt: the value added if successful, else '*noValue*
% index: the position of the new value in the list of values of slot of entity
%
% Examples:
%  addValueBare('generalizations','Bill', 'Presidents')
%  addValueBare('learningMethods', {'example','label'}, 'MLN')


function [rslt index] = addValueBare(slot, entity, value)
global THEO
rslt='*noValue*';

if THEO.readDiskKB && ~isEntityInRAM(entity) % first check whether entity is in RAM
  if ~swapInEntity(entity) % and if not, try swapping it in from disk
    fprintf('**WARNING: addValueBare cannot find %s on disk or in memory.\n',v2p(entity));
    crash;
  end
end

% append VALUE to the list of already existing values for SLOT of ENTITY
valueList=getValueBare(slot,entity);
if strcmp(valueList,'NO_THEO_VALUE')
  valueList={value};
  index=1;
else
  valueList{end+1}=value;
  index=length(valueList);
end

%%%%%%%%%%%%%
if ischar(entity)
  slotStructAddr=[THEO.varPrefix,entity];
else
  slotStructAddr=[THEO.varPrefix,entity{1}];
  for k=2:length(entity)
    slotStructAddr=[slotStructAddr, '.', entity{k}];
  end
end
slotStructAddr=[slotStructAddr, '.',slot, '.val'];
assignin('base','THEO_temp',valueList);
evalin('base',[slotStructAddr, '=THEO_temp;']);
evalin('base','clear THEO_temp;');
rslt=value;
  
if THEO.maintainDiskKB
  saveEntity(entity);
end
