% function [rslt index] = addValue1(slot, entity, value, <source>, <probability>)
%
% KNOWN BUGS: WHEN ADDING A SOURCE/PROBABILITY SUBSLOT, NEED TO ADD A CHECK FOR CASE WHERE
% ALREADY THERE ARE SLOT VALUES, BUT THE SUBSLOT DOESN'T YET EXIST.  IN THIS CASE, NEED TO ADD
% {'UNKNOWN'} SOURCE, AS IN putValueC. SEE '***' COMMENT BELOW.
%
% NOTE: handling of specializations/generalizations currently uses addValueBare, but probably
% should do a recursive call to this function, similar to removeValue's recursive call
%
% Implements Layer 1 addValue function.  Adds to layer 0:
%
% 1. if you addValue('specializations',x,y) it adds
% addValue('generalizations',y,x), and vice versa.
%
% 2. if you give an optional source, it adds it to the source subslot, and if you give an optional
% probability, it adds it to the probability subslot.  If you want to add a probability but no
% source, then use source={}.
%
% 3. if you try to add a value that's already there, it doesn't add
% a second copy.  However, it updates the source and probability subslots
%
%
% Sets SLOT of ENTITY to be VALUE.  Slot must be a string.  Entity may
% be a string naming a top-level entity, or it may be a cell array of
% strings representing a (sub)slot of an entity.  If the latter, the
% slot of that nested entity will be set.  VALUE may be any data type.
%
% Examples:
%  addValue1('grandparents','tom','victor',{'method_1', 0.999}, 0.999)
%  addValue1('grandparents','tom','nora',{'method_2', 0.92}, 0.92)
%  addValue1('grandparents','tom','victor',{'method_2', 0.999}, 0.999)
%  addValue1('grandparents','tom','victor',{}, 0.9977)
%
% the above sequence of 4 commands results in the entity/slot/subslot structure:
%  grandparents = {victor, nora} 
%    source = {{{method_1, 0.999} , {method_2, 0.999} } , {{method_2, 0.92} } } 
%    probability = {0.9977, 0.92} 
%
% HISTORY:
% Tom - 2/20/09 - extended this to accept optional args source and probability
% Tom - 4/28/09 - added print statements for debugging
% Tom - 4/28/09 - DISABLED SAFETY CRASHS LINEs 101 AND 84 FOR RTW EXPERIMENTS
% Andy - 7/1/09 - added handling of NO_THEO_VALUE for specializations value

function [rslt index] = addValue1(slot, entity, value, source, probability)
global THEO
rslt='NO_THEO_VALUE';

if strcmp(slot,'specializations')
  g=getValueBare('generalizations',value);
  if ~ismember(entity,g)
    addValueBare('generalizations',value,entity);
  end
elseif strcmp(slot,'generalizations')
  s=getValueBare('specializations',value);
  if (ischar(s) && strcmp(s, 'NO_THEO_VALUE')) || ~ismember(entity,s)
    addValueBare('specializations',value,entity);
  end
end

oldVal=getValueBare(slot,entity);
if nargin>3
  ea=entSlot2entAddr(entity,slot); % we'll need this below
end

%if ~(iscellstr(oldVal) && ismember(value,oldVal))
if ~(iscell(oldVal) && memberOf(value,oldVal)) % it's a new value, so append it
  [rslt index]=addValueBare(slot,entity,value);
  if nargin>=4  % store optional input source 
    
    % *** NEED HERE TO CHECK FOR POSSIBLE NEEDED ADDITION OF SOURCE SUBSLOT WITH {'UNKNOWN'} SOURCES FOR
    % OTHER ITEMS.  and probability.
    addValueBare('source',ea,{source});
    if nargin>=5  % store optional input probability
      addValueBare('probability',ea,probability);
    end
  end
else % value is already present, but if source or probability are input, then insert these
  if (nargin>=4 && ~isempty(source)) % insert source
    sources=getValueBare('source',ea);
    if ~isTheoValue(sources)
      fprintf('YIKES - addValue1 cannot add a source if there were none there...\n');
      fprintf(' slot:%s, entity:%s\n',slot,v2p(entity));
      fprintf(' value:%s\n',v2p(value));
      fprintf(' source:%s\n',v2p(source));
      fprintf(' probability:%s\n',v2p(probability));
      fprintf(' sources:%s\n',v2p(sources));
      % CRASH;
    else % add the input source to earlier sources for value in position idx
      [r idx]=memberOf(value,oldVal);
      newSources=sources;
      newSources{idx}=[sources{idx}, {source}];
      putValueBare('source',ea,newSources);
    end
  end
  if nargin>=5 % update probability
    probs=getValueBare('probability',ea);
    if ~isTheoValue(probs)
      fprintf('YIKES - addValue1 cannot add a probability if there were none there...');
      fprintf(' slot:%s, entity:%s\n',slot,v2p(entity));
      fprintf(' value:%s\n',v2p(value));
      fprintf(' source:%s\n',v2p(source));
      fprintf(' probability:%s\n',v2p(probability));
      fprintf(' probs:\n',v2p(probs));
      % CRASH;
    else % overwrite old probability of item in position idx by the input probability
      [r idx]=memberOf(value,oldVal);
      probs{idx}=probability;
      putValueBare('probability',ea,probs);
    end
  end
end

