% Used by saveEntity.m to write out slots and their values
% 
% Slot values are stored in xml format with tags for the following
% data types (other types have no tag:
%
%      <l>,</l> = list
%      <s> = string
%      <r> = real value
%      <in> = integer value
%
% special characters in XML include &, <, and >.  Replaces these by &amp; &lt; and &gt;
%
% History
% 9/11/09 Tom: added functionality to handle special chars &,<,> (in value2xmlString)

function slotElement = addSlotChildElement(s,entity,v,fid,indentStr)
global THEO

v=value2xmlString(v);

fprintf(fid,'%s<slot>\n',indentStr);
fprintf(fid,'%s   <name>%s</name>\n',indentStr,s);
fprintf(fid,'%s   <val>%s</val>\n',indentStr,v);

saveSubslotsToo=1;  % for debugging
if saveSubslotsToo
  ee=entSlot2entAddr(entity,s);
  subslotNames=getCachedSlots(ee);
  for k=1:length(subslotNames)
    if ~strcmp('val',subslotNames{k})
      ss=subslotNames{k};
      vv=getValue(ss,ee);
      if isTheoValue(v)
        addSlotChildElement(ss,ee,vv,fid,[indentStr,'   ']);
      end
    end
  end
end

% close <slot> tag
fprintf(fid,'%s</slot>\n',indentStr);


