% define the standard Theo knowledge base
% HISTORY
% 2/23/09 Tom added nrOfValues(probability), entities source, candidateValues
% 3/8/09 Tom changed defaultValue(nrOfValues) to 'any'
% 3/14/09 Tom removed 'inherit' from defaultValue of availableMethods
% 3/14/09 Tom added entities 'prologRules' and 'learnedPrologRules'
% 3/15/09 Tom added ability of 'prologRules' to infer rules from 'learnedPrologRules'
% 3/15/09 Tom changed defaultValue(whenToCache) to ifValueKnown
% 5/22/09 Tom added 'ifValueKnown' to legalValues(whenToCache)
%
% TODO: availableMethods should have nrOfValues=1, as it's a list, not a set!

THEO.maintainDiskHierarchy=0;

ce('everything',{});
ce('slot','everything');
pv('definingSlots','slot',{'whenToCache','legalValues','availableMethods','domain','range','nrOfValues'});
ce('theoSlot','slot');
pv('comment','theoSlot','below here are Theo system-defined slots. Put yours below slot instead.');

ce('slotSlot','slot');
pv('domain','slotSlot','slot');
ce('theoSlotSlot','slotSlot');
pv('comment','theoSlotSlot','below here are the Theo system-defined subslots.');

ce('defaultValue','theoSlotSlot');
ce('confidence','theoSlotSlot');
pv('legalValues','confidence','number');
pv('comment','confidence',['stores confidence in value of the ' ...
                    'associated slot']);

ce('domain','theoSlotSlot');
pv('whenToCache','domain','always');
pv('domain', 'theoSlotSlot', 'slot');
pv('domain', 'domain', 'slot');  % could infer this, but speeds
                                 % things up
pv('defaultValue','domain','everything');
pv('availableMethods','domain',{'inherit','defaultValue'});

ce('range','theoSlotSlot');
ce('comment','theoSlot');
ce('generalizations','theoSlot');
pv('nrOfValues','generalizations','any');
ce('specializations','theoSlot');
pv('nrOfValues','specializations','any');

ce('subset','specializations');
pv('nrOfValues','subset', 'any');
pv('range','subset','slot');

ce('mutuallyExclusiveWith','theoSlot');
pv('nrOfValues','mutuallyExclusiveWith','any');
pv('availableMethods','mutuallyExclusiveWith',{'inherit'});

ce('inverse','theoSlotSlot');
pv('domain','inverse','slot');
pv('range','inverse','slot');
 
ce('legalValues','theoSlotSlot');

ce('nrOfValues','theoSlotSlot');
pv('comment','nrOfValues','indicates how many values the slot can have');
pv('legalValues', 'nrOfValues', {1,2,'any'});
pv('defaultValue', 'nrOfValues', 'any');
pv('availableMethods', 'nrOfValues', {'defaultValue'});

ce('probability','theoSlotSlot');
pv('comment','probability','describes the probabilities associated with the slot values');
pv('availableMethods', 'probability', {});
pv('nrOfValues','probability', 'any');



ce('justification','theoSlotSlot');
pv('comment','justification','for now, this is just the name of the method used to infer its value.');
pv('availableMethods', 'justification', {});


% following is to implement slot value inference
ce('availableMethods','theoSlotSlot');
pv('domain','availableMethods','slot');
pv('whenToCache','availableMethods','always');
%%% pv('whenToCache','availableMethods','always');  SHOULD BE 'IF TOP LEVEL', BUT NEED TO
%IMPLEMENT THIS CACHING STRATEGY FIRST


% 3/14/09 Tom removed 'inherit' from defaultValue of availableMethods
pv('defaultValue','availableMethods',{'dropAllContext','defaultValue'});
%pv('defaultValue','availableMethods',{'dropAllContext','inherit', ...
%                    'defaultValue'});
pv('legalValues','availableMethods',{'dropAllContext','inherit','defaultValue','prolog'});

pv('availableMethods','slot',{'dropAllContext','inherit','defaultValue'});
pv('availableMethods','availableMethods',{'dropAllContext', 'inherit', ...
                    'defaultValue'});
pv('availableMethods','generalizations',{'defaultValue'});
pv('defaultValue','generalizations',{'everything'});
pv('defaultValue','specializations',{});
pv('availableMethods','specializations',{'defaultValue'});
pv('nrOfValues','availableMethods','any');

ce('whenToCache','theoSlotSlot');
pv('defaultValue','whenToCache','ifValueKnown');
pv('availableMethods','whenToCache',{'dropAllContext','inherit','defaultValue'});
pv('whenToCache','whenToCache','always');
pv('nrOfValues','whenToCache',1);
pv('legalValues','whenToCache',{'always','never','ifValueKnown'});
pv('domain','whenToCache','slot');

pv('whenToCache','generalizations','never');
pv('whenToCache','specializations','never');
pv('whenToCache','comment','never');

ce('toget','theoSlotSlot');
pv('whenToCache','toget','never');
pv('nrOfValues','toget',1);
pv('defaultValue','toget','togetBare');
pv('toget','toget','togetBare');

ce('prologRules','theoSlotSlot');
pv('comment','prologRules','stores horn clauses used to compute slots values for its domain element. Also copied from learnedPrologRules');
pv('availableMethods','prologRules',{'prolog'});
pv('prologRules','prologRules',{{{{'prologRules' '?s' '?r'} {'learnedPrologRules' '?s' '?r'}} 1.0}});
pv('defaultValue','prologRules',{});
pv('whenToCache','prologRules','never');
pv('nrOfValues','prologRules','any');
pv('domain','prologRules','slot');

ce('learnedPrologRules','theoSlotSlot');
pv('comment','learnedPrologRules','stores horn clauses learned by trainAndCommitFOLRs. These can be used by the prolog method to infer new slot values');
pv('availableMethods','learnedPrologRules',{});
pv('defaultValue','learnedPrologRules',{});
pv('whenToCache','learnedPrologRules','never');
pv('nrOfValues','learnedPrologRules','any');
pv('domain','learnedPrologRules','slot');

ce('source','theoSlotSlot');
pv('comment','source','subslot to store justifications for slot values');
pv('whenToCache','source','never');
pv('nrOfValues','source','any');

ce('candidateValues','theoSlotSlot');
pv('comment','candidateValues','subslot to store alternative candidate values for slots whose nrOfValues=1');
pv('whenToCache','candidateValues','never');
pv('nrOfValues','candidateValues','any');


THEO.maintainDiskHierarchy=1;
webdisplayHierarchy('everything');
