%  kb of family tree
 
oldMaintainDiskKB=THEO.maintainDiskKB;   % for efficiency
THEO.maintainDiskKB=0;
oldMaintainDiskHierarchy=THEO.maintainDiskHierarchy;
THEO.maintainDiskHierarchy=0;

ce('relationships','slot');
pv('domain','relationships', 'person');
pv('range','relationships', 'person');
pv('availableMethods','relationships', {'prolog' 'inherit' 'defaultValue'});

ce('ancestors','relationships');
pv('nrOfValues','ancestors','any');   
pv('whentocache','ancestors','always');

ce('descendants','relationships');
pv('nrOfValues','descendants','any');   
pv('whentocache','descendants','always');


ce('person','everything');
pv('partitions','person', {'male', 'female'});
pv('definingSlots','person', {'mother', 'father', 'spouse', 'sons', 'daughters'});

ce('male','person');

ce('female','person');

ce('bob','male');
pv('father','bob', 'victor');
pv('spouse','bob', 'louise');
pv('parents','bob',{'victor','nora'});

ce('joan','female');
pv('spouse','joan', 'tom');

ce('louise','female');
pv('spouse','louise', 'bob');

ce('meghan','female');
pv('father','meghan', 'tom');

ce('nora','female');
pv('spouse','nora', 'victor');

ce('rob','male');
pv('father','rob', 'bob');

ce('shannon','female');
pv('father','shannon', 'tom');

ce('sharon','female');
pv('father','sharon', 'bob');

ce('tom','male');
pv('father','tom', 'bob');
av('parents','tom', 'bob');
pv('spouse','tom', 'joan');

ce('will','male');
pv('spouse','will', 'sharon');

ce('victor','male');
pv('spouse','victor', 'nora');

ce('spouse','relationships');
pv('partitions','spouse',{'husband', 'wife'});
pv('nrOfValues','spouse', 1);
pv('whentocache','spouse','always');

ce('husband','spouse');
pv('domain','husband','female');    
pv('range','husband','male');
pv('nrOfValues','husband', 1);
pv('whentocache','husband','always');
pv('availableMethods', 'husband', {'prolog'});  
pv('prologRules', 'husband', {...
    {{{'husband' '?female' '?husband'} {'spouse' '?female' '?husband'} {'generalizations' '?husband' 'male'}} 1.0}...
                   });

ce('wife','spouse');
pv('domain','wife','male');   
pv('range','wife','female');
pv('nrOfValues','wife', 1);
pv('whentocache','wife','always');


ce('parents','ancestors');
pv('partitions','parents',{'father', 'mother'});
pv('nrOfValues','parents', 2);   
pv('whentocache','parents','always');
pv('prologRules', 'parents', {...
    {{{'parents' '?x' '?p'} {'father' '?x' '?p'}} 0.98}...
    {{{'parents' '?x' '?p'} {'mother' '?x' '?p'}} 0.99}...
                   });


ce('father','parents');
pv('range','father','male');   
pv('nrOfValues','father', 1);
pv('whentocache','father','always');
    
ce('mother','parents');
pv('range','mother','female');   
pv('whentocache','mother','always');
pv('nrOfValues','mother', 1);


ce('children','descendants');
pv('partitions','children',{'sons', 'daughters'});
pv('nrOfValues','children', 'any');   
pv('whentocache','children','always');
pv('prologRules', 'children', {...
    {{{'children' '?x' '?p'} {'sons' '?x' '?p'}} 1.0}...
    {{{'children' '?x' '?p'} {'daughters' '?x' '?p'}} 1.0}...
                   });



ce('sons','children');
pv('range','sons','male');
pv('nrOfValues','sons', 'any');   
pv('whentocache','sons','always');

ce('daughters','children');
pv('range','daughters','female');
pv('nrOfValues','daughters', 'n');   
pv('whentocache','daughters','always');

ce('parentsInLaw','relationships');
pv('partitions','parentsInLaw',{'fatherInLaw','motherInLaw'});
pv('nrOfValues','parentsInLaw',2);   
pv('whentocache','parentsInLaw','always');


ce('fatherInLaw','parentsInLaw');
pv('range','fatherInLaw','male');   
pv('nrOfValues','fatherInLaw',1);
pv('whentocache','fatherInLaw','always');
    
ce('motherInLaw','parentsInLaw');
pv('range','motherInLaw','female');   
pv('nrOfValues','motherInLaw',1);
pv('whentocache','motherInLaw','always');

ce('siblings','relationships');
pv('partitions','siblings',{'brothers', 'sisters'});
pv('nrOfValues','siblings','any');   
pv('whentocache','siblings','always');

ce('brothers','siblings');
pv('range','brothers','male');
pv('nrOfValues','brothers','any');   
pv('whentocache','brothers','always');

ce('sisters','siblings');
pv('range','sisters','female');
pv('nrOfValues','sisters','any');   
pv('whentocache','sisters','always');

ce('siblingsInLaw','relationships');
pv('partitions','siblingsInLaw',{'brothersInLaw', 'sistersInLaw'});
pv('nrOfValues','siblingsInLaw','any');   
pv('whentocache','siblingsInLaw','always');

ce('brothersInLaw','siblingsInLaw');
pv('range','brothersInLaw','male');
pv('nrOfValues','brothersInLaw','any');   
pv('whentocache','brothersInLaw','always');

ce('sistersInLaw','siblingsInLaw');
pv('range','sistersInLaw','female');
pv('nrOfValues','sistersInLaw','any');   
pv('whentocache','sistersInLaw','always');

ce('grandparents','ancestors');
pv('prologRules', 'grandparents', {...
    {{{'grandparents' '?x' '?pp'} {'parents' '?x' '?p'} {'parents' '?p' '?pp'}} 1.0}...
                   });

pv('partitions','grandparents',{'grandfathers', 'grandmothers'});
pv('nrOfValues','grandparents',4);   
pv('whentocache','grandparents','always');

ce('grandfathers','grandparents');
pv('range','grandfathers','male');
pv('nrOfValues','grandfathers',2);   
pv('whentocache','grandfathers','always');

ce('grandmothers','grandparents');
pv('prologRules', 'grandmothers', {...
    {{{'grandmothers' '?x' '?pp'} {'parents' '?x' '?p'} {'parents' '?p' '?pp'} {'generalizations' '?pp' 'female'}} 1.0} ...
                   });
pv('range','grandmothers','female');
pv('nrOfValues','grandmothers',2);   
pv('whentocache','grandmothers','always');

ce('uncles','relationships');
pv('range','uncles','male');
pv('nrOfValues','uncles','any');   
pv('whentocache','uncles','always');

ce('aunts','relationships');
pv('range','aunts','female');
pv('nrOfValues','aunts','any');   
pv('whentocache','aunts','always');

ce('cousins','relationships');
pv('nrOfValues','cousins','any');   
pv('whentocache','cousins','always');

ce('nephews','relationships');
pv('range','nephews','male');
pv('nrOfValues','nephews','any');   
pv('whentocache','nephews','always');

ce('nieces','relationships');
pv('range','nieces','female');
pv('nrOfValues','nieces','any');   
pv('whentocache','nieces','always');

THEO.maintainDiskKB=oldMaintainDiskKB;   % restore original settings
THEO.maintainDiskHierarchy=oldMaintainDiskHierarchy;

