/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.util;

import java.text.StringCharacterIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtility {
    private XmlUtility() {
    }

    public static Element getChildByName(String name, Element parent) {
        NodeList nameNodes = parent.getElementsByTagName(name);
        for (int j = 0; j < nameNodes.getLength(); ++j) {
            if (nameNodes.item(j).getParentNode() != parent) continue;
            return (Element)nameNodes.item(j);
        }
        return null;
    }

    public static Node getFirstElementChild(Node parent) {
        for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
            if (parent.getChildNodes().item(i).getNodeType() != 1) continue;
            return parent.getChildNodes().item(i);
        }
        return null;
    }

    public static Node getNthElementChild(Node parent, int n) {
        int counter = 0;
        for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
            if (parent.getChildNodes().item(i).getNodeType() != 1) continue;
            if (counter == n) {
                return parent.getChildNodes().item(i);
            }
            ++counter;
        }
        return null;
    }

    public static int numElementChildren(Node parent) {
        int result = 0;
        for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
            if (parent.getChildNodes().item(i).getNodeType() != 1) continue;
            ++result;
        }
        return result;
    }

    public static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static String escapeXmlString(String aText) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '&') {
                result.append("&amp;");
            } else if (character < ' ' && character != '\t' && character != '\n') {
                result.append(" ");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

