/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.util;

public class Timer {
    private long startTime = 0L;
    private long endTime = 0L;

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
    }

    public void stop() {
        this.endTime = System.currentTimeMillis();
    }

    public String getElapsedTimeHrMin() {
        long deltaMin = this.computeDeltaSec() / 60L;
        long deltaHr = deltaMin / 60L;
        return deltaHr + " hr " + deltaMin % 60L + " min";
    }

    public int getElapsedMin() {
        long deltaMin = this.computeDeltaSec() / 60L;
        return (int)deltaMin;
    }

    public int getElapsedMilliseconds() {
        long deltaMilliSec = this.computeDeltaMilliSec();
        return (int)deltaMilliSec;
    }

    private long computeDeltaSec() {
        return this.computeDeltaMilliSec() / 1000L;
    }

    private long computeDeltaMilliSec() {
        long end = 0L;
        if (this.startTime == 0L) {
            throw new IllegalStateException("Must start the timer before requesting the elapsed time.");
        }
        end = this.endTime == 0L ? System.currentTimeMillis() : this.endTime;
        return end - this.startTime;
    }
}

