/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.util;

import edu.cmu.ml.rtw.util.StringUtility;
import edu.cmu.ml.rtw.util.XmlUtility;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilityTest {
    @Test
    public void testEscapeXmlString() {
        String a = "Test";
        String b = XmlUtility.escapeXmlString(a);
        if (!b.equals(a)) {
            Assert.fail();
        }
        if (!(b = XmlUtility.escapeXmlString(a = "A&B")).equals("A&amp;B")) {
            Assert.fail();
        }
    }

    @Test
    public void testSeparateNonTokenizedPunc() {
        String s = "``!?this--/NN _is_/VBZ foo-based-/JJ !!??crazy...!---/JJ";
        String result = StringUtility.separateNonTokenizedPunc(s);
        System.out.println(result);
        Assert.assertTrue((boolean)result.equals("``/`` !/. ?/. this/NN --/-- _/SYM is/VBZ _/SYM foo-based/JJ -/-- !/. !/. ?/. ?/. crazy/JJ .../: !/. --/-- -/--"));
        s = "'ll/MD 'd/MD 've/VBP I/PRP 'm/VBP one/NN 's/POS text/NN 's/VBZ not/NEG 're/VBP";
        result = StringUtility.separateNonTokenizedPunc(s);
        System.out.println(result);
        Assert.assertTrue((boolean)result.equals("'ll/MD 'd/MD 've/VBP I/PRP 'm/VBP one/NN 's/POS text/NN 's/VBZ not/NEG 're/VBP"));
        s = "test/VB a.m./NN a./NN A./NNP A.C.R.O.N.Y.M./NNP";
        result = StringUtility.separateNonTokenizedPunc(s);
        System.out.println(result);
        Assert.assertTrue((boolean)result.equals("test/VB a.m./NN a/NN ./. A/NNP ./. A.C.R.O.N.Y.M./NNP"));
        s = "China,/NNP India/NNP ,/, Russia./NNP .!!/.";
        result = StringUtility.separateNonTokenizedPunc(s);
        System.out.println(result);
        Assert.assertTrue((boolean)result.equals("China/NNP ,/, India/NNP ,/, Russia/NNP ./. .!!/."));
    }

    @Test
    public void testCreatePuncTags() {
        String puncs = "...!?";
        String result = StringUtility.createPuncTags(puncs);
        Assert.assertTrue((boolean)result.equals(".../: !/. ?/."));
        puncs = "!...?#";
        result = StringUtility.createPuncTags(puncs);
        Assert.assertTrue((boolean)result.equals("!/. .../: ?/. #/SYM"));
        puncs = "!?#...";
        result = StringUtility.createPuncTags(puncs);
        Assert.assertTrue((boolean)result.equals("!/. ?/. #/SYM .../:"));
    }

    @Test
    public void testContainsDigit() {
        Assert.assertTrue((boolean)StringUtility.containsDigit("askdjfas3jas  d"));
        Assert.assertFalse((boolean)StringUtility.containsDigit("askdjfasjas  d"));
    }
}

