/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtility {
    private static Map<String, String> puncTag = new HashMap<String, String>();

    private StringUtility() {
    }

    public static boolean containsDigit(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isDigit(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String padTabAlign(String string, int fieldLength) {
        int length = fieldLength - string.length();
        if (length <= 0) {
            return string.substring(0, fieldLength - 3) + "...";
        }
        StringBuffer buffer = new StringBuffer(fieldLength);
        for (int i = 0; i < (int)Math.ceil((double)length / 8.0); ++i) {
            buffer.append("\t");
        }
        buffer.insert(0, string);
        return new String(buffer);
    }

    public static String separateNonTokenizedPunc(String taggedSentence) {
        String[] tokens = taggedSentence.split(" ");
        String result = "";
        for (String tokenTag : tokens) {
            String[] parts = tokenTag.split("/");
            String token = parts[0];
            String tag = parts[1];
            String newStr = "";
            if (token.matches("^([A-Za-z]\\.){2,}$") || token.equals("'d") && tag.equals("MD") || token.equals("'ll") && tag.equals("MD") || token.equals("'s") && tag.equals("POS") || token.equals("'ve") && tag.startsWith("VB") || token.equals("'s") && tag.startsWith("VB") || token.equals("'re") && tag.startsWith("VB") || token.equals("'m") && tag.startsWith("VB")) {
                result = result + tokenTag.trim() + " ";
                continue;
            }
            Matcher m = Pattern.compile("(\\p{Punct}*)(.*[^\\p{Punct}]+)(\\p{Punct}*)$").matcher(token);
            if (m.find()) {
                if (m.group(1).length() > 0) {
                    newStr = newStr + StringUtility.createPuncTags(m.group(1)) + " ";
                }
                newStr = newStr + m.group(2) + "/" + tag + " ";
                if (m.group(3).length() > 0) {
                    newStr = newStr + StringUtility.createPuncTags(m.group(3)) + " ";
                }
            } else {
                newStr = tokenTag.trim() + " ";
            }
            result = result + newStr;
        }
        return result.trim();
    }

    public static String createPuncTags(String punctuation) {
        String result = "";
        for (int i = 0; i < punctuation.length(); ++i) {
            boolean used = false;
            for (int j = punctuation.length(); j > i; --j) {
                String punc = punctuation.substring(i, j);
                String tag = puncTag.get(punc);
                if (tag == null) continue;
                result = result + punc + "/" + tag + " ";
                i = j - 1;
                used = true;
                break;
            }
            if (used) continue;
            result = result + punctuation.substring(i, i + 1) + "/SYM ";
        }
        return result.trim();
    }

    static {
        puncTag.put("``", "``");
        puncTag.put("`", "``");
        puncTag.put("'", "''");
        puncTag.put("\"", "''");
        puncTag.put("(", "-LRB-");
        puncTag.put("{", "-LCB-");
        puncTag.put("[", "-LSB-");
        puncTag.put(")", "-RRB-");
        puncTag.put("}", "-RCB-");
        puncTag.put("]", "-RSB-");
        puncTag.put(",", ",");
        puncTag.put("-", "--");
        puncTag.put("--", "--");
        puncTag.put(".", ".");
        puncTag.put("!", ".");
        puncTag.put("?", ".");
        puncTag.put(":", ":");
        puncTag.put(";", ":");
        puncTag.put("...", ":");
    }
}

