/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;

    public Properties() {
    }

    public Properties(Properties properties) {
        super(properties);
    }

    public String getProperty(String name) {
        return this.get(name) != null ? ((String)this.get(name)).trim() : null;
    }

    public void setProperty(String name, String value) {
        this.put(name, value);
    }

    public String getProperty(String name, String defaultValue) {
        String value = ((String)this.get(name)).trim();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Set<String> getPropertyNames() {
        return this.keySet();
    }

    public int getPropertyIntegerValue(String key) {
        int value = 0;
        try {
            value = Integer.valueOf(this.getProperty(key).trim());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public double getPropertyDoubleValue(String key) {
        double value = 0.0;
        try {
            value = Double.valueOf(this.getProperty(key).trim());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public boolean getPropertyBooleanValue(String key) {
        boolean value = false;
        try {
            value = Boolean.valueOf(this.getProperty(key).trim());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public int[] getPropertyIntegerValueArray(String key) {
        String arrayLine = this.getProperty(key).trim();
        String[] arrayValues = arrayLine.split(";");
        int[] intArray = new int[arrayValues.length];
        for (int i = 0; i < arrayValues.length; ++i) {
            intArray[i] = Integer.valueOf(arrayValues[i].trim());
        }
        return intArray;
    }

    public double[] getPropertyDoubleValueArray(String key) {
        String arrayLine = this.getProperty(key).trim();
        String[] arrayValues = arrayLine.split(";");
        double[] doubleArray = new double[arrayValues.length];
        for (int i = 0; i < arrayValues.length; ++i) {
            doubleArray[i] = Double.valueOf(arrayValues[i].trim());
        }
        return doubleArray;
    }

    public String[] getPropertyValueArray(String key) {
        String[] arrayValues;
        if (this.getProperty(key) == null) {
            return new String[0];
        }
        String arrayLine = this.getProperty(key).trim();
        for (String val : arrayValues = arrayLine.split(";")) {
            val.trim();
        }
        return arrayValues;
    }

    public Vector<String> getPropertyLowerCaseValueVector(String key) {
        Vector<String> valueSet = new Vector<String>();
        if (this.getProperty(key) != null) {
            String[] arrayValues;
            String arrayLine = this.getProperty(key).trim();
            for (String val : arrayValues = arrayLine.split(";")) {
                if (valueSet.contains(val)) continue;
                valueSet.add(val.trim().toLowerCase());
            }
        }
        return valueSet;
    }

    public Map<String, Boolean> toBooleanMap() {
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        for (Map.Entry property : this.entrySet()) {
            boolean val = false;
            try {
                val = Boolean.parseBoolean(((String)property.getValue()).trim());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            res.put((String)property.getKey(), val);
        }
        return res;
    }

    public Map<String, Integer> toIntegerMap() {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        for (Map.Entry property : this.entrySet()) {
            int val = 0;
            try {
                val = Integer.parseInt(((String)property.getValue()).trim());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            res.put((String)property.getKey(), val);
        }
        return res;
    }

    public void load(InputStream is) throws IOException {
        java.util.Properties properties = new java.util.Properties();
        properties.load(is);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void loadFromXML(InputStream is) throws IOException {
        java.util.Properties properties = new java.util.Properties();
        properties.loadFromXML(is);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public Properties filterProperties(String prefix, boolean remove_prefix) {
        Properties properties = new Properties();
        for (Map.Entry property : this.entrySet()) {
            String key = (String)property.getKey();
            if (!key.startsWith(prefix)) continue;
            if (remove_prefix) {
                key = key.substring(prefix.length());
            }
            properties.put(key, property.getValue());
        }
        return properties;
    }

    public Map<String, Properties> mapProperties() {
        TreeMap<String, Properties> properties_map = new TreeMap<String, Properties>();
        try {
            for (Map.Entry property : this.entrySet()) {
                String key = (String)property.getKey();
                int i = key.indexOf(46);
                if (i == -1) {
                    Properties properties = (Properties)properties_map.get(key);
                    if (properties == null) {
                        properties = new Properties();
                        properties_map.put(key, properties);
                    }
                    properties.put(key, property.getValue());
                    continue;
                }
                String name = key.substring(0, i);
                String property_name = key.substring(i + 1);
                Properties properties = (Properties)properties_map.get(name);
                if (properties == null) {
                    properties = new Properties();
                    properties_map.put(name, properties);
                }
                properties.put(property_name, property.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties_map;
    }

    public java.util.Properties toJavaProperties() {
        java.util.Properties properties = new java.util.Properties();
        properties.putAll((Map<?, ?>)this);
        return properties;
    }

    public static Properties loadFromClassName(String className) {
        String propertyFileName = className + ".properties";
        return Properties.loadProperties(propertyFileName);
    }

    public static Properties loadProperties(String propertyFileName) {
        Properties p = new Properties();
        try {
            FileInputStream inStream = new FileInputStream("conf/" + propertyFileName);
            if (inStream == null) {
                throw new IllegalStateException("Could not find " + propertyFileName + " in the conf/ folder");
            }
            p.load(inStream);
        }
        catch (Exception e) {
            System.err.println("Caught exception while loading properties: " + e.getMessage());
        }
        return p;
    }
}

