/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.util;

import edu.cmu.ml.rtw.util.MapUtility;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MapUtilityTest {
    @Test
    public void testSortMapByValue() {
        HashMap<String, Double> m = new HashMap<String, Double>();
        m.put("a", 3.0);
        m.put("b", 2.0);
        m.put("c", 5.0);
        m.put("d", 9.0);
        List l = MapUtility.sortMapByValue(m, false);
        if (!((String)l.get(0).getKey()).equals("b")) {
            Assert.fail((String)"ascending order: b should be first");
        }
        if (!((String)l.get(1).getKey()).equals("a")) {
            Assert.fail((String)"ascending order: a should be 2nd");
        }
        if (!((String)l.get(2).getKey()).equals("c")) {
            Assert.fail((String)"ascending order: c should be 3rd");
        }
        if (!((String)l.get(3).getKey()).equals("d")) {
            Assert.fail((String)"ascending order: d should be 4th");
        }
        if (!((String)(l = MapUtility.sortMapByValue(m, true)).get(3).getKey()).equals("b")) {
            Assert.fail((String)"descending order: b should be 4th");
        }
        if (!((String)l.get(2).getKey()).equals("a")) {
            Assert.fail((String)"descending order: a should be 3rd");
        }
        if (!((String)l.get(1).getKey()).equals("c")) {
            Assert.fail((String)"descending order: c should be 2nd");
        }
        if (!((String)l.get(0).getKey()).equals("d")) {
            Assert.fail((String)"descending order: d should be 1st");
        }
    }

    @Test
    public void testGetFromMapWithDefault() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        int i = MapUtility.getFromMapWithDefault(m, "foo", 5);
        if (i != 5) {
            Assert.fail();
        }
        m.put("bar", 3);
        i = MapUtility.getFromMapWithDefault(m, "bar", 5);
        if (i != 3) {
            Assert.fail();
        }
        if ((i = MapUtility.getFromMapWithDefault(m, "foo", 5).intValue()) != 5) {
            Assert.fail();
        }
    }
}

