/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.util;

import edu.cmu.ml.rtw.util.Cache;
import edu.cmu.ml.rtw.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K extends Comparable, V>
implements Cache<K, V>,
Serializable {
    Map<K, Item<K, V>> m_map = Collections.synchronizedMap(new HashMap());
    Item<K, V> m_start = new Item();
    Item<K, V> m_end = new Item();
    int m_maxSize;
    Object m_listLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeItem(Item<K, V> item) {
        Object object = this.m_listLock;
        synchronized (object) {
            item.previous.next = item.next;
            item.next.previous = item.previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertHead(Item<K, V> item) {
        Object object = this.m_listLock;
        synchronized (object) {
            item.previous = this.m_start;
            item.next = this.m_start.next;
            this.m_start.next.previous = item;
            this.m_start.next = item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveToHead(Item<K, V> item) {
        Object object = this.m_listLock;
        synchronized (object) {
            item.previous.next = item.next;
            item.next.previous = item.previous;
            item.previous = this.m_start;
            item.next = this.m_start.next;
            this.m_start.next.previous = item;
            this.m_start.next = item;
        }
    }

    public LRUCache(int maxObjects) {
        this.m_maxSize = maxObjects;
        this.m_start.next = this.m_end;
        this.m_end.previous = this.m_start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pair<K, V>> getAll() {
        ArrayList<Pair<K, V>> p = new ArrayList<Pair<K, V>>(this.m_map.size());
        Object object = this.m_listLock;
        synchronized (object) {
            Item cur = this.m_start.next;
            while (cur != this.m_end) {
                p.add(Pair.create(cur.key, cur.value));
                cur = cur.next;
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pair<K, V>> getAllDirty() {
        ArrayList<Pair<K, V>> p = new ArrayList<Pair<K, V>>(this.m_map.size());
        Object object = this.m_listLock;
        synchronized (object) {
            Item cur = this.m_start.next;
            while (cur != this.m_end) {
                if (cur.dirty) {
                    p.add(Pair.create(cur.key, cur.value));
                }
                cur = cur.next;
            }
        }
        return p;
    }

    @Override
    public V get(K key) {
        Item<K, V> cur = this.m_map.get(key);
        if (cur == null) {
            return null;
        }
        if (System.currentTimeMillis() > cur.expires) {
            this.m_map.remove(cur.key);
            this.removeItem(cur);
            return null;
        }
        if (cur != this.m_start.next) {
            this.moveToHead(cur);
        }
        return cur.value;
    }

    @Override
    public Pair<K, V> put(K key, V obj, boolean dirty) {
        return this.put(key, obj, dirty, -1L);
    }

    @Override
    public Pair<K, V> put(K key, V value, boolean dirty, long validTime) {
        Item<K, V> cur = this.m_map.get(key);
        if (cur != null) {
            cur.value = value;
            cur.expires = validTime > 0L ? System.currentTimeMillis() + validTime : Long.MAX_VALUE;
            cur.dirty = cur.dirty || dirty;
            this.moveToHead(cur);
            return null;
        }
        Pair result = null;
        if (this.m_map.size() >= this.m_maxSize) {
            cur = this.m_end.previous;
            if (cur.dirty) {
                result = Pair.create(cur.key, cur.value);
            }
            this.m_map.remove(cur.key);
            this.removeItem(cur);
        }
        long expires = 0L;
        expires = validTime > 0L ? System.currentTimeMillis() + validTime : Long.MAX_VALUE;
        Item<K, V> item = new Item<K, V>(key, value, expires);
        item.dirty = dirty;
        this.insertHead(item);
        this.m_map.put(key, item);
        return result;
    }

    @Override
    public void remove(K key) {
        Item<K, V> cur = this.m_map.get(key);
        if (cur == null) {
            return;
        }
        this.m_map.remove(key);
        this.removeItem(cur);
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Item<K, V> {
        public K key;
        public V value;
        public long expires;
        public Item<K, V> previous;
        public Item<K, V> next;
        public boolean dirty;

        public Item(K k, V v, long e) {
            this.key = k;
            this.value = v;
            this.expires = e;
        }

        public Item() {
        }
    }
}

