/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.kb;

import edu.cmu.ml.rtw.kb.KbManipulation;
import edu.cmu.ml.rtw.kb.RTWValue;
import edu.cmu.ml.rtw.util.XmlUtility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTWPutValueCommand {
    String slot;
    List<String> entity;
    RTWValue value;
    double probability;
    String sourceName;
    String sourceDate;
    int sourceIteration;
    String sourceComment;

    public RTWPutValueCommand(String slot, List<String> entity, RTWValue value, double probability, String sourceName, String sourceDate, int iteration, String comment) {
        this.slot = slot;
        this.entity = entity;
        this.value = value;
        this.probability = probability;
        this.sourceName = sourceName;
        this.sourceDate = sourceDate;
        this.sourceIteration = iteration;
        this.sourceComment = comment;
    }

    public RTWPutValueCommand(String xmlString) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
            doc = db.parse(is);
        }
        catch (Exception e) {
            System.out.print("Problem parsing the PutValue XML.");
            System.out.println(e);
        }
        Element root = doc.getDocumentElement();
        this.slot = root.getElementsByTagName("slot").item(0).getTextContent().trim();
        this.entity = new ArrayList<String>();
        Node entityNode = root.getElementsByTagName("entity").item(0);
        int j = 0;
        while (!entityNode.getChildNodes().item(j).getNodeName().equals("l") && !entityNode.getChildNodes().item(j).getNodeName().equals("s")) {
            ++j;
        }
        if (entityNode.getChildNodes().item(j).getNodeName().equals("l")) {
            NodeList entityNodeChildren = entityNode.getChildNodes().item(j).getChildNodes();
            for (int i = 0; i < entityNodeChildren.getLength(); ++i) {
                if (!entityNodeChildren.item(i).getNodeName().equals("s")) continue;
                this.entity.add(entityNodeChildren.item(i).getTextContent().trim());
            }
        } else {
            this.entity.add(entityNode.getChildNodes().item(j).getTextContent().trim());
        }
        String valueString = root.getElementsByTagName("value").item(0).getTextContent().trim();
        Node typeNode = XmlUtility.getFirstElementChild(root.getElementsByTagName("value").item(0));
        String type = typeNode.getNodeName();
        this.value = KbManipulation.parseRTWValue(typeNode);
        this.probability = Double.parseDouble(root.getElementsByTagName("probability").item(0).getTextContent());
        Node source = root.getElementsByTagName("source").item(0);
        NodeList sourceChildren = source.getChildNodes();
        for (int i = 0; i < sourceChildren.getLength(); ++i) {
            if (sourceChildren.item(i).getNodeName().equals("name")) {
                this.sourceName = sourceChildren.item(i).getTextContent().trim();
                continue;
            }
            if (sourceChildren.item(i).getNodeName().equals("comment")) {
                this.sourceComment = sourceChildren.item(i).getTextContent().trim();
                continue;
            }
            if (sourceChildren.item(i).getNodeName().equals("date")) {
                this.sourceDate = sourceChildren.item(i).getTextContent().trim();
                continue;
            }
            if (!sourceChildren.item(i).getNodeName().equals("iteration")) continue;
            this.sourceIteration = Integer.parseInt(sourceChildren.item(i).getTextContent().trim());
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("SLOT: " + this.slot + "\n");
        result.append("ENTITY: " + this.entity + "\n");
        result.append("VALUE: " + this.value + "\n");
        result.append("PROBABILITY: " + this.probability + "\n");
        result.append("SOURCE NAME: " + this.sourceName + "\n");
        result.append("SOURCE DATE: " + this.sourceDate + "\n");
        result.append("SOURCE COMMENT: " + this.sourceComment + "\n");
        result.append("SOURCE ITERATION: " + this.sourceIteration + "\n");
        return result.toString();
    }

    public String getSlot() {
        return this.slot;
    }

    public List<String> getEntity() {
        return this.entity;
    }

    public RTWValue getValue() {
        return this.value;
    }

    public double getProbability() {
        return this.probability;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceDate() {
        return this.sourceDate;
    }

    public int getIteration() {
        return this.sourceIteration;
    }

    public String getComment() {
        return this.sourceComment;
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<command><name>RTWPutValue</name><slot>");
        sb.append(XmlUtility.escapeXmlString(this.slot));
        sb.append("</slot><entity>");
        if (this.entity.size() > 1) {
            sb.append("<l>");
            for (int i = 0; i < this.entity.size(); ++i) {
                sb.append("<s>");
                sb.append(XmlUtility.escapeXmlString(this.entity.get(i)));
                sb.append("</s>");
            }
            sb.append("</l>");
        } else {
            sb.append("<s>");
            sb.append(XmlUtility.escapeXmlString(this.entity.get(0)));
            sb.append("</s>");
        }
        sb.append("</entity><value>");
        sb.append(this.value.toXml());
        sb.append("</value><probability>");
        sb.append(this.probability);
        sb.append("</probability><source><name>");
        sb.append(XmlUtility.escapeXmlString(this.sourceName));
        sb.append("</name><date>");
        sb.append(XmlUtility.escapeXmlString(this.sourceDate));
        sb.append("</date><iteration>");
        sb.append(this.sourceIteration);
        sb.append("</iteration><comment>");
        sb.append(XmlUtility.escapeXmlString(this.sourceComment));
        sb.append("</comment></source></command>");
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        String xml = "<command>        <name> RTWPutValue </name>        <slot> candidateValues </slot>        <entity> <l><s> Steve Ballmer </s> <s> generalizations </s> </l>        </entity>        <value> <s> person </s> </value>        <probability> 0.8  </probability>        <source>              <name>  CBL </name>              <date>2009/03/14-12:10:42 </date>              <iteration> 3 </iteration>              <comment> From:ceo_of </comment>         </source>   </command>";
        String xml2 = new RTWPutValueCommand(xml).toXML();
        System.out.println(new RTWPutValueCommand(xml));
        System.out.println(xml2);
        System.out.println(new RTWPutValueCommand(xml2).toXML());
    }
}

