/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.ml.rtw.kb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import edu.cmu.ml.rtw.kb.KbManipulation;
import edu.cmu.ml.rtw.kb.RTWListValue;
import edu.cmu.ml.rtw.kb.RTWStringValue;
import edu.cmu.ml.rtw.kb.RTWValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KbUtility {
    static final Logger log = Logger.getLogger(KbUtility.class);

    public static Set<String> getMutexPredicates(String slotValue) {
        Preconditions.checkNotNull((Object)slotValue);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        RTWListValue mutexPredicates = (RTWListValue)KbManipulation.getValue("mutexPredicates", KbManipulation.normalizeEntityName(slotValue));
        for (RTWValue v : mutexPredicates.getVal()) {
            builder.add((Object)v.asString());
        }
        return builder.build();
    }

    public static boolean checkCategoryInstanceForMutex(String category, Set<String> mutexPreds, String candidate) {
        Preconditions.checkNotNull((Object)category);
        Preconditions.checkNotNull(mutexPreds);
        Preconditions.checkNotNull((Object)candidate);
        candidate = KbManipulation.normalizeEntityName(candidate);
        if (!KbManipulation.doesEntityExist(candidate)) {
            return true;
        }
        if (KbManipulation.isAncestor(category, candidate)) {
            return true;
        }
        RTWValue candidateGeneralizations = KbManipulation.getValue("generalizations", candidate);
        if (!(candidateGeneralizations instanceof RTWListValue)) {
            if (candidate.equals("everything")) {
                return false;
            }
            throw new RuntimeException("error: generalizations should be an RTWListValue for entity:" + candidate);
        }
        RTWListValue candidateGeneralizationsList = (RTWListValue)candidateGeneralizations;
        for (RTWValue v : candidateGeneralizationsList.getVal()) {
            for (String pred : mutexPreds) {
                pred = KbManipulation.normalizeEntityName(pred);
                if (!KbManipulation.normalizeEntityName(v.asString()).equals(pred) && !KbManipulation.isAncestor(pred, v.asString())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkRelationInstanceWithKnownNegatives(String relation, String arg1, String arg2) {
        Preconditions.checkNotNull((Object)relation);
        Preconditions.checkNotNull((Object)arg1);
        Preconditions.checkNotNull((Object)arg2);
        arg1 = KbManipulation.normalizeEntityName(arg1);
        arg2 = KbManipulation.normalizeEntityName(arg2);
        RTWValue knownNegs = KbManipulation.getValue("knownNegatives", relation);
        if (knownNegs instanceof RTWListValue) {
            RTWListValue knownNegList = (RTWListValue)knownNegs;
            for (RTWValue v : knownNegList.getVal()) {
                RTWListValue valuePair = (RTWListValue)v;
                String vArg1 = valuePair.getVal().get(0).asString();
                String vArg2 = valuePair.getVal().get(1).asString();
                vArg1 = KbManipulation.normalizeEntityName(vArg1);
                vArg2 = KbManipulation.normalizeEntityName(vArg2);
                if (!vArg1.equals(arg1) || !vArg2.equals(arg2)) continue;
                log.debug((Object)("found known negative: " + relation + "\t" + arg1 + "\t" + arg2));
                return false;
            }
        }
        return true;
    }

    public static boolean checkRelationInstanceForMutex(String relation, Set<String> mutexPreds, Set<String> allSlots, String arg1, String arg2) {
        Preconditions.checkNotNull((Object)relation);
        Preconditions.checkNotNull(mutexPreds);
        Preconditions.checkNotNull(allSlots);
        Preconditions.checkNotNull((Object)arg1);
        Preconditions.checkNotNull((Object)arg2);
        arg1 = KbManipulation.normalizeEntityName(arg1);
        arg2 = KbManipulation.normalizeEntityName(arg2);
        if (KbManipulation.doesEntityExist(arg1)) {
            if (KbManipulation.hasSlotValue(relation, arg1, new RTWStringValue(arg2))) {
                return true;
            }
            ArrayList matchingSlots = Lists.newArrayList();
            for (String s : allSlots) {
                if (!KbManipulation.hasSlotValue(s, arg1, new RTWStringValue(arg2))) continue;
                matchingSlots.add(s);
            }
            for (String s : matchingSlots) {
                for (String pred : mutexPreds) {
                    pred = KbManipulation.normalizeEntityName(pred);
                    if (!KbManipulation.normalizeEntityName(s).equals(pred) && !KbManipulation.isAncestor(pred, s)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static Set<String> getRelations(boolean populateFilter) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        RTWListValue relations = (RTWListValue)KbManipulation.getValue("specializations", "rtwRelation");
        for (RTWValue relation : relations.getVal()) {
            String populateString = KbManipulation.getValue("populate", relation.asString()).asString();
            if (populateFilter && !populateString.equals("true")) continue;
            builder.add((Object)relation.asString());
        }
        return builder.build();
    }

    public static Set<String> getCategories(boolean populateFilter) throws IOException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        RTWListValue categories = (RTWListValue)KbManipulation.getValue("specializations", "rtwCategory");
        for (RTWValue category : categories.getVal()) {
            String populateString = KbManipulation.getValue("populate", category.asString()).asString();
            if (populateFilter && !populateString.equals("true")) continue;
            builder.add((Object)category.asString());
        }
        return builder.build();
    }
}

